/* ***************************************************************************************
* FILE:          RtCaretImpl.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtCaretImpl is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <Candera/System/Mathematics/Vector2.h>
#include <FeatStd/MemoryManagement/SharedPointer.h>

#include <Widgets/2D/RichText/Engine/RtCaret.h>
#include <Widgets/2D/RichText/DocumentModel/RtParagraphItem.h>

namespace hmibase {
namespace widget {
namespace richtext {

class Engine;

/**
 * Implementation of Caret interface.
 * This class is not intended being used by clients directly.
 */
class CaretImpl: public Caret
{
      FEATSTD_TYPEDEF_BASE(Caret);
   public:
      FEATSTD_RTTI_DECLARATION();
      FEATSTD_TYPEDEF_SHARED_POINTER(CaretImpl);

      static CaretImpl::SharedPointer Create(Engine* engine);
      virtual ~CaretImpl();

      virtual void SetVisiblity(bool visible) override;
      virtual bool GetVisiblity() const override;

      virtual Candera::Vector2 GetPosition(bool screenCoordinates) override;
      virtual void SetPosition(const Candera::Vector2& position, bool screenCoordinates) override;
      virtual void SetPosition(ParagraphItem::SharedPointer item, FeatStd::UInt32 offset) override;

      virtual ParagraphItem::SharedPointer GetAffectedParagraphItem() override;
      virtual FeatStd::UInt32 GetAffectedParagraphItemOffset() override;

   protected:
      CaretImpl();

   private:
      // Finds the paragraph item at the given position in document space and
      // sets the the affectedItem and affectedItemOffset members accordingly.
      void FindParagraphItemAt(const Candera::Vector2& position, bool screenCoordinates = true);

      bool m_visible;                              // Whether or not the caret is visible
      Candera::Vector2 m_position;                 // The position of the caret in pixels within document scope
      ParagraphItem::SharedPointer m_affectedItem; // The paragraph item currently affected by the caret
      FeatStd::UInt32 m_affectedItemOffset;        /* The number of document units of the caret position relative to the
                                                      start of paragraph item currently affected by the caret.*/
};


} // namespace richtext
} // namespace widget
} // namespace hmibase
