/* ***************************************************************************************
* FILE:          RtCaretBasedDocManipulatorImpl.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtCaretBasedDocManipulatorImpl is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <FeatStd/Util/String.h>
#include <Candera/System/Mathematics/Vector2.h>
#include <FeatStd/MemoryManagement/SharedPointer.h>

#include <Widgets/2D/RichText/Engine/RtCaretBasedDocManipulator.h>
#include <Widgets/2D/RichText/Engine/RtCaret.h>
#include <Widgets/2D/RichText/Engine/RtDocUnits.h>
#include <Widgets/2D/RichText/DocumentModel/RtDocument.h>
#include <Widgets/2D/RichText/StyleProvider/RtElementStyle.h>

namespace hmibase {
namespace widget {
namespace richtext {

class Engine;

/**
 * Implementation of CaretBasedDocManipulator interface.
 * This class is not intended being used by clients directly.
 */
class CaretBasedDocManipulatorImpl: public CaretBasedDocManipulator
{
      FEATSTD_TYPEDEF_BASE(CaretBasedDocManipulator);

   public:
      FEATSTD_RTTI_DECLARATION();
      FEATSTD_TYPEDEF_SHARED_POINTER(CaretBasedDocManipulatorImpl);

      static CaretBasedDocManipulatorImpl::SharedPointer Create(Engine* engine);

      virtual ~CaretBasedDocManipulatorImpl();

      virtual Caret::SharedPointer GetCaret()  override;
      virtual ParagraphItem::SharedPointer GetItemAtCaret() override;

      virtual void PlaceCaret(FeatStd::Int32 posX, FeatStd::Int32 posY, bool screenCoordinates) override;
      virtual void PlaceCaret(const Candera::Vector2& position, bool screenCoordinates) override;
      virtual Candera::Vector2 GetCaretPosition(bool screenCoordinates) override;

      virtual void PlaceCaretAtBegin() override;
      virtual void PlaceCaretAtEnd() override;
      virtual void MoveCaret(FeatStd::Int32 count, DocUnits::Enum unit) override;

      virtual void InsertBeforeCaret(const FeatStd::String& text) override;
      virtual void InsertBeforeCaret(const FeatStd::String& text, const ElementStyle::SharedPointer style) override;

      virtual void InsertAfterCaret(const FeatStd::String& text) override;
      virtual void InsertAfterCaret(const FeatStd::String& text, const ElementStyle::SharedPointer style) override;

      virtual void DeleteBeforeCaret(FeatStd::UInt32 count) override;
      virtual void DeleteAfterCaret(FeatStd::UInt32 count) override;

   protected:
      CaretBasedDocManipulatorImpl();

   private:

      Caret::SharedPointer m_caret;
};


} // namespace richtext
} // namespace widget
} // namespace hmibase
