/* ***************************************************************************************
* FILE:          RtParagraphItem.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtParagraphItem is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <Widgets/2D/RichText/DocumentModel/RtDocElement.h>

namespace hmibase {
namespace widget {
namespace richtext {

/** The base class for paragraph content elements. */
class ParagraphItem : public DocElement
{
      FEATSTD_TYPEDEF_BASE(DocElement);

   public:
      FEATSTD_RTTI_DECLARATION();
      FEATSTD_TYPEDEF_SHARED_POINTER(ParagraphItem);

      ParagraphItem();

      /** Retrieves the amount of stored items.
          @return     In case of e.g. a Block this is the amount of Text, Image and Link items.
                      In case of e.g. a Text this is the amount of glyphs. */
      virtual FeatStd::UInt16 GetItemCount() const;

      /** Provides the number of atomic parts, such as letters or images, of the paragraph item.
          @return The number of atomic parts of this item.
          @note The default implemention returns always 1. */
      virtual FeatStd::UInt16 GetPartCount() const;

      /** Retrieves the position the atomic part at index 'partIdx' within the paragraph item.
          @param partIdx  The index of the atomic part of which the position is retrieved.
          @return         The position of the left upper corner of the addressed atomic part. */
      virtual Candera::Vector2 GetPartPosition(FeatStd::UInt16 partIdx) const;

      /** Retrieves the bounding rectangle the 'partIdx'th atomic part of this paragraph item.
          @param partIdx  The index of the atomic part of which the bounding rectangle is retrieved. The index is clipped to 'GetPartCount'.
          @return         The bounding rectangle relative to the left upper corner of the item. */
      virtual Candera::Rectangle GetPartBoundaries(FeatStd::UInt16 partIdx) const;

      /** Provides the first paragraph item having no further children.
          @ return The first child paragraph item without parent or this
                   object if it cannot have children. */
      virtual ParagraphItem::SharedPointer GetFirstLeafParagraphItem();

      /** Provides the last paragraph item having no further children.
          @ return The last child paragraph item without parent or this
                   object if it cannot have children. */
      virtual ParagraphItem::SharedPointer GetLastLeafParagraphItem();
};


} // namespace richtext
} // namespace widget
} // namespace hmibase
