/* ***************************************************************************************
* FILE:          RtParagraphItem.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtParagraphItem is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "RtParagraphItem.h"

namespace hmibase {
namespace widget {
namespace richtext {

FEATSTD_RTTI_DEFINITION(ParagraphItem, Base);

ParagraphItem::ParagraphItem() :
   Base()
{
}


ParagraphItem::SharedPointer ParagraphItem::GetFirstLeafParagraphItem()
{
   return ParagraphItem::SharedPointer(this);
}


ParagraphItem::SharedPointer ParagraphItem::GetLastLeafParagraphItem()
{
   return ParagraphItem::SharedPointer(this);
}


FeatStd::UInt16 ParagraphItem::GetItemCount() const
{
   return 0;
}


FeatStd::UInt16 ParagraphItem::GetPartCount() const
{
   return 1;
}


Candera::Vector2 ParagraphItem::GetPartPosition(FeatStd::UInt16 partIdx) const
{
   Candera::Vector2 partPosition(0.0F, 0.0F);

   if (partIdx > 0)
   {
      partPosition.SetX(GetRect().GetWidth());
   }
   return partPosition;
}


Candera::Rectangle ParagraphItem::GetPartBoundaries(FeatStd::UInt16 partIdx) const
{
   Candera::Rectangle partBoundary(GetRect());

   if (partIdx > 0)
   {
      partBoundary.SetLeft(GetRect().GetWidth());
      partBoundary.SetWidth(0.0F);
   }
   return partBoundary;
}


} // namespace richtext
} // namespace widget
} // namespace hmibase
