/* ***************************************************************************************
* FILE:          RtParagraph.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtParagraph is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <Widgets/2D/RichText/DocumentModel/RtDocElement.h>
#include <Widgets/2D/RichText/DocumentModel/RtBlock.h>
#include <hmibase/util/Macros.h>

namespace hmibase {
namespace widget {
namespace richtext {

/** Represents a paragraph of the document. A paragraph is typically a self-contained unit within a chapter and implicitly defines content flow. */
class Paragraph : public DocElement
{
      FEATSTD_TYPEDEF_BASE(DocElement);

   public:
      FEATSTD_RTTI_DECLARATION();
      FEATSTD_TYPEDEF_SHARED_POINTER(Paragraph);

      Paragraph(bool isTitle = false);

      void AddChild(const Block::SharedPointer& block);
      virtual ParagraphItem::SharedPointer GetFirstLeafParagraphItem();
      virtual ParagraphItem::SharedPointer GetLastLeafParagraphItem();

      virtual bool Process(DocElementTraverser& traverser, const Candera::Rectangle& effectiveRect) const override;

#if defined (RICHTEXT_LOGGING_ENABLED)
      virtual void Log(std::ostream& stream, const Candera::Rectangle& effectiveRect, bool repeatLastLine = false,
                       StreamIterationData& data = StreamIterationData::defaultData) const override;
#endif

   private:
      typedef FeatStd::Internal::Vector<Block::SharedPointer> BlockList;

      BlockList m_blocks;
      bool m_isTitle;
};


} // namespace richtext
} // namespace widget
} // namespace hmibase
