/* ***************************************************************************************
* FILE:          RtParagraph.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtParagraph is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "RtParagraph.h"
#include "RtDocument.h"

namespace hmibase {
namespace widget {
namespace richtext {

FEATSTD_RTTI_DEFINITION(Paragraph, Base);

Paragraph::Paragraph(bool isTitle /* = false */) :
   Base(),
   m_isTitle(isTitle)
{
}


void Paragraph::AddChild(const Block::SharedPointer& block)
{
   FEATSTD_DEBUG_ASSERT(block->GetParent() == 0);
   (void)m_blocks.Add(block);
   block->SetParent(this);
   RICHTEXT_LOG_DOCELEMENT(block);
}


ParagraphItem::SharedPointer Paragraph::GetFirstLeafParagraphItem()
{
   ParagraphItem::SharedPointer leafItem;
   if (!m_blocks.Empty())
   {
      leafItem = (*m_blocks.Begin())->GetFirstLeafParagraphItem();
   }

   return leafItem;
}


ParagraphItem::SharedPointer Paragraph::GetLastLeafParagraphItem()
{
   ParagraphItem::SharedPointer leafItem;
   if (!m_blocks.Empty())
   {
      leafItem = (*m_blocks.Begin())->GetLastLeafParagraphItem();
   }

   return leafItem;
}


bool Paragraph::Process(DocElementTraverser& traverser, const Candera::Rectangle& effectiveRect) const
{
   bool terminate = Base::Process(traverser, effectiveRect);
   return (!terminate) && ProcessChildList<Block>(m_blocks, traverser, effectiveRect);
}


#if defined (RICHTEXT_LOGGING_ENABLED)
void Paragraph::Log(std::ostream& stream, const Candera::Rectangle& effectiveRect, bool repeatLastLine /* = false */,
                    StreamIterationData& data /* = StreamIterationData::default */) const
{
   data.name = m_isTitle ? "Title" : "Paragraph";
   Base::Log(stream, effectiveRect, repeatLastLine, data);
   RICHTEXT_LOG(stream, std::endl);
}


#endif
} // namespace richtext
} // namespace widget
} // namespace hmibase
