/* ***************************************************************************************
* FILE:          RtImage.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtImage is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "RtImage.h"

namespace hmibase {
namespace widget {
namespace richtext {

FEATSTD_RTTI_DEFINITION(Image, Base);

Image::Image() :
   Base(),
   m_name("")
{
}


Image::~Image()
{
}


#if defined (RICHTEXT_LOGGING_ENABLED)
void Image::Log(std::ostream& stream, const Candera::Rectangle& effectiveRect, bool repeatLastLine /*= false*/,
                StreamIterationData& data /*= StreamIterationData::defaultData*/) const
{
   data.name = "Image";
   Base::Log(stream, effectiveRect, repeatLastLine, data);

   RICHTEXT_LOG(stream, " '" << m_name.GetCString() << "'");
   RICHTEXT_LOG(stream, std::endl);
}


#endif
} // namespace richtext
} // namespace widget
} // namespace hmibase
