/* ***************************************************************************************
* FILE:          RtDocument.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtDocument is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "RtDocument.h"
#include "RtDocHelper.h"

namespace hmibase {
namespace widget {
namespace richtext {

FEATSTD_RTTI_DEFINITION(Document, Base);

Document::Document() :
   Base()
{
   RICHTEXT_LOG(m_creationStream,
                std::endl <<
                "Create Document:" << std::endl <<
                "----------------" << std::endl);

   RICHTEXT_LOG_DOCELEMENT(this);
}


void Document::SetBody(const Chapter::SharedPointer& body)
{
   FEATSTD_DEBUG_ASSERT(body->GetParent() == 0);
   m_body = body;
   body->SetParent(this);
   RICHTEXT_LOG_DOCELEMENT(body);
}


Chapter::SharedPointer Document::GetBody() const
{
   return m_body;
}


ParagraphItem::SharedPointer Document::GetFirstLeafParagraphItem()
{
   ParagraphItem::SharedPointer leafItem;
   if (m_body != 0)
   {
      leafItem = m_body->GetFirstLeafParagraphItem();
   }
   return leafItem;
}


ParagraphItem::SharedPointer Document::GetLastLeafParagraphItem()
{
   ParagraphItem::SharedPointer leafItem;
   if (m_body != 0)
   {
      leafItem = m_body->GetLastLeafParagraphItem();
   }
   return leafItem;
}


bool Document::Process(DocElementTraverser& traverser, const Candera::Rectangle& effectiveRect) const
{
   bool terminate = Base::Process(traverser, effectiveRect);

   traverser.IncLevel();
   terminate = (!terminate) && m_body->Process(traverser, traverser.GetEffeciveRect(*m_body, effectiveRect));
   traverser.DecLevel();
   return terminate;
}


#if defined (RICHTEXT_LOGGING_ENABLED)
void Document::Log(std::ostream& stream, const Candera::Rectangle& effectiveRect, bool repeatLastLine /*= false*/,
                   StreamIterationData& data /*= StreamIterationData::default*/) const
{
   data.name = "Document";
   Base::Log(stream, effectiveRect, repeatLastLine, data);
   RICHTEXT_LOG(stream, std::endl);
}


#endif
} // namespace richtext
} // namespace widget
} // namespace hmibase
