/* ***************************************************************************************
* FILE:          RtDocElementTraverser.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtDocElementTraverser is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <Candera/System/Mathematics/Rectangle.h>

namespace hmibase {
namespace widget {
namespace richtext {

class DocElement;

/** Helper class to traverse over DocElement tree and call Process() method for each element found in the hierarchy. */
class DocElementTraverser
{
   public:
      DocElementTraverser() :
         m_level(0)
      {
      }

      void IncLevel();
      void DecLevel();

      FeatStd::UInt8 GetLevel() const;
      Candera::Rectangle GetEffeciveRect(const DocElement& object, const Candera::Rectangle& parentRect) const;

   protected:
      // returns true to abort further processing, false otherwise
      virtual bool Process(const DocElement& docElement, const Candera::Rectangle& effectiveRect) = 0;

   private:
      friend class DocElement;

      FeatStd::UInt8 m_level;
};


inline
void DocElementTraverser::IncLevel()
{
   m_level++;
}


inline
void DocElementTraverser::DecLevel()
{
   m_level--;
}


inline
FeatStd::UInt8 DocElementTraverser::GetLevel() const
{
   return m_level;
}


} // namespace richtext
} // namespace widget
} // namespace hmibase
