/* ***************************************************************************************
* FILE:          RtDocElementTraverser.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtDocElementTraverser is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "RtDocElementTraverser.h"
#include "RtDocElement.h"

namespace hmibase {
namespace widget {
namespace richtext {

Candera::Rectangle DocElementTraverser::GetEffeciveRect(const DocElement& object, const Candera::Rectangle& parentRect) const
{
   const Candera::Rectangle& rect = object.GetRect();
   if ((rect.GetWidth() < 0.0F) && (rect.GetHeight() < 0.0F))
   {
      return parentRect;
   }

   Candera::Rectangle effectiveRect(rect);
   effectiveRect.SetPosition(parentRect.GetPosition() + rect.GetPosition());

   const bool rectIsValid =
      (!FeatStd::Internal::Math::FloatAlmostEqual(rect.GetWidth(), 0.0F)) ||
      (!FeatStd::Internal::Math::FloatAlmostEqual(rect.GetHeight(), 0.0F));
   const bool parentRectIsValid =
      (!FeatStd::Internal::Math::FloatAlmostEqual(parentRect.GetWidth(), 0.0F)) ||
      (!FeatStd::Internal::Math::FloatAlmostEqual(parentRect.GetHeight(), 0.0F));

   if (rectIsValid && parentRectIsValid)
   {
      FeatStd::Float effectiveTop = effectiveRect.GetTop();
      if (effectiveTop < parentRect.GetTop())
      {
         effectiveRect.SetTop(effectiveTop);
      }
   }

   return effectiveRect;
}


} // namespace richtext
} // namespace widget
} // namespace hmibase
