/* ***************************************************************************************
* FILE:          RtDocumentFab.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtDocumentFab is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <Widgets/2D/RichText/DocumentModel/RtDocument.h>
#include <Widgets/2D/RichText/Engine/RtMarkups.h>
#include <Widgets/2D/RichText/Engine/RtEngine.h>

namespace hmibase {
namespace widget {
namespace richtext {

class FormattedDocFab;
class Engine;

/**
    Creates a Rich Text Document from the provided textual source. The textual source is formatted in the indicated format.
    The singleton instance of this class acts as common entry point for document creation. It selects the appropriate 'FormattedDocFab'
    implementation for the indicated format and delegates the actual creation process to that particular document fabric. The resulting
    document instance is returned and the ownership about the document object is transferred to the calling client.
    */
class DocumentFab
{
   public:
      /**
       *  @return     The singleton instance.
       */
      static DocumentFab& GetInstance();

      void Prepare(Engine& engine) const;

      /**
       *  Creates a Rich Text Document from the given source in the indicated format. The created document instance is returned as shared
       *  pointer to transfer also object ownership.
       */
      Document::SharedPointer CreateDocument(Engine& engine) const;

   private:
      DocumentFab();

      FormattedDocFab::SharedPointer GetDocFab(Engine& engine) const;
};


} // namespace richtext
} // namespace widget
} // namespace hmibase
