/* ***************************************************************************************
* FILE:          RtAbstractFormattedDocFab.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtAbstractFormattedDocFab is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <Widgets/2D/RichText/DocumentFactory/RtFormattedDocFab.h>

namespace hmibase {
namespace widget {
namespace richtext {

/**
 *  The abstract base class for registrable document factories.
 */
class AbstractFormattedDocFab : public FormattedDocFab
{
   public:
      FEATSTD_RTTI_DECLARATION();

      virtual void Prepare(Engine& engine) override = 0;
      virtual Document::SharedPointer CreateDocument(Engine& engine) override = 0;
};


} // namespace richtext
} // namespace widget
} // namespace hmibase
