/* ***************************************************************************************
* FILE:          RtUrlResolver.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtUrlResolver is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "RtUrlResolver.h"
#include <FeatStd/Util/PointerUtil.h>

namespace hmibase {
namespace widget {
namespace richtext {

static FeatStd::SizeType GetToken(const FeatStd::TChar* string, const FeatStd::TChar* delimiter, FeatStd::String* token, FeatStd::SizeType startPos)
{
   FeatStd::SizeType rc = 0;

   if (string != 0)
   {
      std::string::size_type delimiterPos;
      std::string stdString = string;
      if (startPos > 0)
      {
         stdString = stdString.substr(startPos);
      }
      if (delimiter != 0)
      {
         delimiterPos = stdString.find(delimiter);

         if (delimiterPos != std::string::npos)
         {
            if (token != 0)
            {
               *token = FeatStd::String(stdString.c_str(), delimiterPos, false);
            }

            if (stdString.at(delimiterPos) != '\0')
            {
               delimiterPos += FeatStd::Internal::String::Length(delimiter);
               rc = startPos + delimiterPos;
            }
         }
      }
      else
      {
         if (token != 0)
         {
            *token = FeatStd::String(stdString.c_str());
         }
      }
   }

   return rc;
}


void UrlResolver::SplitUrl(Url baseUrl, Url resourceUrl, UrlSegments& urlSegments)
{
   FeatStd::Internal::CharBuffer<1000> buf;
   buf.Format("%s%s", baseUrl != 0 ? baseUrl : "", resourceUrl != 0 ? resourceUrl : "");
   const FeatStd::Char* url = buf.c_str();

   FeatStd::SizeType next = GetToken(url, ":", &(urlSegments.scheme), 0);
   if (next != 0)
   {
      if (url[next] == '/' && url[next + 1] == '/')
      {
         next = GetToken(url, "/", &(urlSegments.authority), (next + 2));
      }
      else
      {
         next = GetToken(url, "/", &(urlSegments.authority), next);
      }
      if (next != 0)
      {
         next = GetToken(url, 0, &(urlSegments.path), next);
      }
   }
}


} // namespace richtext
} // namespace widget
} // namespace hmibase
