/* ***************************************************************************************
* FILE:          RtContentProvider.cpp.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtContentProvider.cpp is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "RtContentProvider.h"
#include <FeatStd/Util/StaticObject.h>
#include "RtAssetUrlResolver.h"
#include <hmibase/util/Macros.h>

namespace hmibase {
namespace widget {
namespace richtext {

ContentProvider& ContentProvider::GetInstance()
{
   FEATSTD_SYNCED_STATIC_OBJECT(ContentProvider, s_contentPovider);
   return s_contentPovider;
}


Candera::Bitmap::SharedPointer ContentProvider::GetBitmap(Url baseUrl, Url resourceUrl) const
{
   UrlResolver::UrlSegments urlSegments;
   UrlResolver::SplitUrl(baseUrl, resourceUrl, urlSegments);
   if (urlSegments.scheme == "asset")
   {
      return AssetUrlResolver::GetInstance().GetBitmap(baseUrl, resourceUrl);
   }

   return Candera::Bitmap::SharedPointer();
}


TextInStream::SharedPointer ContentProvider::GetTextResource(Url baseUrl, Url resourceUrl) const
{
   UrlResolver::UrlSegments urlSegments;
   UrlResolver::SplitUrl(baseUrl, resourceUrl, urlSegments);
   if (urlSegments.scheme == "asset")
   {
      return AssetUrlResolver::GetInstance().GetTextResource(baseUrl, resourceUrl);
   }

   return TextInStream::SharedPointer();
}


Candera::TextRendering::SharedStyle::SharedPointer ContentProvider::GetTextStyle(Url baseUrl, Url resourceUrl) const
{
   UrlResolver::UrlSegments urlSegments;
   UrlResolver::SplitUrl(baseUrl, resourceUrl, urlSegments);
   if (urlSegments.scheme == "asset")
   {
      return AssetUrlResolver::GetInstance().GetTextStyle(baseUrl, resourceUrl);
   }

   return Candera::TextRendering::SharedStyle::SharedPointer();
}


ContentProvider::ContentProvider()
{
}


} // namespace richtext
} // namespace widget
} // namespace hmibase
