/* ***************************************************************************************
* FILE:          ProgressBarWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ProgressBarWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(CANDERA_PROGRESSBAR_2D_WIDGET_H)
#define CANDERA_PROGRESSBAR_2D_WIDGET_H


#include "Widgets/2D/ProgressBarWidget2D/generated/ProgressBarWidget2DBase.h"
#include "Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h"

class ProgressBarWidget2D : public ProgressBarWidget2DBase
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(ProgressBarWidget2D, ProgressBarWidget2DBase);

      ProgressBarWidget2D();
      virtual ~ProgressBarWidget2D();

      /**
      * Initializes the widget so that all referred resource can be resolved
      */
      virtual void InitWidget();

      virtual void OnParentViewRenderingEnabled(bool enable);

      /** Is called whenever the parent view (scene) is loaded or unloaded.
      @param load if the scene context was loaded or before it gets unloaded. */
      virtual void OnParentViewLoad(bool load);

      /**
      * Invalidate the scene as long as Animation is running.
      */
      virtual void Update();

      /**
      * Courier messages will be routed to this function.
      * If widget is interested in any message then, on receiving message will act accordigly.
      */
      virtual bool OnMessage(const Courier::Message& msg);     // override

      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

   private:

      void updateProgressBar();

      void updateProgressBarBuffer();

      /**
      * Update the Progressbar based on the timeout value.
      * The width of the ProgressBarFillNode to be displayed is calculated based on the
      * _stepIndex value and TimerStepCount(Number of parts of the ProgressBarFillNode which should fill in the given TimerCount value).
      */
      void updatePbarBasedOnTimer();

      /**
      * For the given MaskNode(mask node for ProgressFillNode OR mask node for ProgressBufferNode),
      * the initial position of the mask node is set based on the Orientation configured (Left, Rigth, Top, Bottom).
      *
      */
      Candera::Vector2 arrangeMaskNodeInitialPosition(Candera::Node2D* node) const;

      /**
      * For the given MaskNode(mask node for ProgressFillNode OR mask node for ProgressBufferNode),
      * the position of the mask node is set based on the Orientation configured (Left, Rigth, Top, Bottom) and the CurrentValue(current ProgressBarFill value)
      *  or CurrentBufferValue(Current buffer value).
      *
      */
      void updateMaskNodePosition(Candera::Node2D* node, Candera::Vector2 maskNodePosition , Candera::Float progressPos_X, Candera::Float progressPos_Y) const;

      /**
      * Calculated the static position of the nodes required for future computation.
      */
      void initialSetup();

      // member variables
      ::Util::Timer         _repeatTimer;
      Candera::Rectangle    _bgBoundingRect; // holds the dimension within which the ProgressBarFillNode/ProgressBufferFillNode will be seen.
      Candera::UInt32       _stepIndex;
      bool                  _shouldUpdateProgressBar;
      bool                  _bufferValueUpdated;
      Candera::Rectangle   _fillNodeBoundingRectangle;
      Candera::Rectangle   _bufferNodeBoundingRectangle;
      Candera::Vector2     _maskNodeStaticPosition;
      Candera::Vector2     _bufferMaskNodeStaticPosition; // holds the position of the mask node used to control the buffer node
      Candera::Float      _stepSize_X;  // Width of ProgressBar to be filled on each Timer updated
      Candera::Float      _stepSize_Y;  // Height of ProgressBar to be filled on each Timer updated

      bool _invalidate;

      CdaWidget2DDef(ProgressBarWidget2D, ProgressBarWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   protected:
      virtual void OnChanged(::Candera::UInt32 propertyId);
};


#endif
