/* ***************************************************************************************
 * FILE:          PageEditWidget2D.cpp
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  PageEditWidget2D is part of HMI-Base Widget Library
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */

#include "widget2D_std_if.h"
#include "PageEditWidget2D.h"
#include "PageEditController2D.h"

#include <Trace/ToString.h>
#include <View/CGI/CgiExtensions/ArrayUtils.h>
#include <Widgets/2D/Gizmo/GizmoWidget2D.h>
#include <Widgets/2D/ControlTemplate/ControlTemplateBinding.h>

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_PAGEEDIT
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/PageEditWidget2D.cpp.trc.h"
#endif


namespace hmibase {
namespace widget {
namespace pageedit {

CGI_WIDGET_RTTI_DEFINITION(PageEditWidget2D)

/*****************************************************************************/
PageEditWidget2D::PageEditWidget2D() : Base()
{
   SetTouchable(false);
}


/*****************************************************************************/
PageEditWidget2D::~PageEditWidget2D()
{
}


/*****************************************************************************/
bool PageEditWidget2D::CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap)
{
   bool cloned(false);
   if (Base::CloneFrom(originalWidget, controlTemplateMap))
   {
      const PageEditWidget2D* original = CLONEABLE_WIDGET_CAST<const PageEditWidget2D*>(originalWidget);
      if (original == NULL)
      {
         return false;
      }

      ETG_TRACE_USR4_DCL((APP_TRACECLASS_ID(), "CloneFrom original=%50s %s",
                          HMIBASE_TO_STRING_VW(original),
                          HMIBASE_TO_STRING_W(this)));

      SetAlbumId(original->GetAlbumId());
      SetColumnCount(original->GetColumnCount());
      SetRowCount(original->GetRowCount());
      SetCellSize(original->GetCellSize());
      SetItemsNode(controlTemplateMap.ResolveNodeClone(original->GetItemsNode()));
      SetArrangeItems(original->GetArrangeItems());
      SetAutoArrange(original->GetAutoArrange());
      SetEditingCellsNode(controlTemplateMap.ResolveNodeClone(original->GetEditingCellsNode()));

      if (!hmibase::util::Arrays::equals(GetItemCells(), original->GetItemCells()))
      {
         SetItemCells(original->GetItemCells());
      }
      cloned = true;
   }
   return cloned;
}


/*****************************************************************************/
hmibase::widget::WidgetController* PageEditWidget2D::GetDefaultController() const
{
   return &(DefaultPageEditController2D::GetInstance());
}


/*****************************************************************************/
bool PageEditWidget2D::SearchItems(std::vector<ItemWidget*>& items)
{
   PageEditController2D* controller = Candera::Dynamic_Cast<PageEditController2D*>(GetController());
   return (controller != NULL) && controller->SearchItems(*this, items);
}


}
}


}
