/* ***************************************************************************************
* FILE:          PageEditStrategy.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  PageEditStrategy.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#pragma once

#include "PageEditCell.h"


namespace hmibase {
namespace widget {
namespace pageedit {

class Album;
struct ArrangementParams;
struct Page;
class PageEditWidget2D;
struct Session;

/*****************************************************************************/
class PageEditStrategy
{
   public:
      virtual ~PageEditStrategy() {}

      virtual bool RearrangeItems(Session& session, CellRectMap& newCellRectMap) = 0;
      virtual bool ValidateNewBounds(Session& session, CellRectMap& newCellRectMap) = 0;
      virtual bool SaveNewBounds(Session& session, const CellRectMap& newCellRectMap) = 0;
};


/*****************************************************************************/
class DefaultPageEditStrategy : public PageEditStrategy
{
   public:
      static DefaultPageEditStrategy& GetInstance()
      {
         static DefaultPageEditStrategy _instance;
         return _instance;
      }

      virtual bool RearrangeItems(Session& session, CellRectMap& newCellRectMap);
      virtual bool ValidateNewBounds(Session& session, CellRectMap& newCellRectMap);
      virtual bool SaveNewBounds(Session& session, const CellRectMap& newCellRectMap);

   protected:
      static bool SlideRows(Session& session, CellGrid& cellGrid, CellIndexType direction, CellIndexType column, CellIndexVector& rowSlideDelta, CellRectMap& newCellRectMap);
      static bool SlideColumns(Session& session, CellGrid& cellGrid, CellIndexType direction, CellIndexType row, CellIndexVector& columnSlideDelta, CellRectMap& newCellRectMap);

      static CellIndexType GetRangeMinValue(const CellIndexVector& v, size_t index, size_t count);
      static CellIndexType GetRangeMaxValue(const CellIndexVector& v, size_t index, size_t count);
      static void SetRangeValue(CellIndexVector& v, size_t index, size_t count, CellIndexType value);
};


}
}


}
