/* ***************************************************************************************
* FILE:          PageEditManager.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  PageEditManager.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#pragma once

#include <FeatStd/Event/EventListener.h>
#include <FeatStd/MemoryManagement/SharedPointer.h>
#include <AppUtils/ObjectGuard.h>
#include <Trace/IOSExtensions.h>
#include "PageEditCell.h"
#include "PageEditData.h"
#include "PageEditWidget2D.h"

namespace hmibase {
namespace widget {
namespace gizmo {
class EditUpdEvent;
}


namespace pageedit {


/*****************************************************************************/
class PageEditManager : public FeatStd::EventListener, public hmibase::view::MessageHandler
{
   public:
      static PageEditManager& GetInstance()
      {
         static PageEditManager _instance;
         return _instance;
      }

      //overrides from MessageHandler
      virtual bool onMessage(const Courier::Message& msg) override;

      //overrides from EventListener
      virtual FeatStd::EventResult::Enum OnEvent(const FeatStd::Event& e) override;

      bool BeginEditing(const ItemId& itemId);
      void EndEditing();
      void AbortEditing();

      bool RearrangeItems();

      Cell PositionToCell(const Candera::Vector2& position, const Candera::Vector2& cellSize) const;
      CellRect BoundsToCellRect(const Candera::Vector2& position, const Candera::Vector2& size, const Candera::Vector2& cellSize) const;
      void PostUpdateMessage(enEditStatus::Enum status);

      Session* GetSession() const;
      Session* BeginSession(Album& album);
      void EndSession();

      Album* GetOrCreateAlbum(const AlbumId& albumId);
      Album* GetAlbum(const AlbumId& albumId);

      bool IsTraceEnabled() const;
      void PrintBigText(char const* text) const;

   private:
      PageEditManager();
      ~PageEditManager();

      PageEditManager(const PageEditManager&);
      PageEditManager& operator=(const PageEditManager&);

      void Initialize();
      bool InitArrangementParams();
      void DetermineDestination();

      bool BeginEditing(Album& album, Page::SharedPointer page, ItemIndexType itemIndex);
      Cell PositionToCell(Item& item, const Candera::Vector2& cellSize, const Candera::Vector2& position) const;
      Page::SharedPointer FindCell(const Candera::Vector2& position, Candera::Vector2& normalizedPosition, Cell& cell) const;
      CellRegion GetCellRegion(const CellRect& cellRect, const Candera::Vector2& normalizedPosition) const;
      CellRegion GetCellRegion(const CellRect& cellRect, const Cell& cell) const;
      Candera::Vector2 GetCurrentTouchCoordinate() const;

      bool OnItemEditUpdEvent(const hmibase::widget::gizmo::EditUpdEvent& e);
      bool OnItemEditStart(const hmibase::widget::gizmo::EditUpdEvent& e);
      bool OnItemEditMove(const hmibase::widget::gizmo::EditUpdEvent& e);
      bool OnItemEditEnd(const hmibase::widget::gizmo::EditUpdEvent& e);

      bool OnTimerExpiredMsg(const TimerExpiredMsg& msg);
      void RestartTimer();
      void StopTimer();

      Session* _session;
      Util::Timer* _movementTimer;

      typedef std::map<AlbumId, Album*> AlbumsType;
      AlbumsType _albums;
};


}
}


}
