/* ***************************************************************************************
* FILE:          PageEditController2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  PageEditController2D.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#pragma once

#include <AppUtils/ObjectGuard.h>
#include <FeatStd/MemoryManagement/SharedPointer.h>
#include <View/CGI/Widget/WidgetController.h>
#include "PageEditCell.h"
#include "PageEditData.h"

namespace Candera {
class WidgetBase;
}


namespace hmibase {
namespace widget {
namespace gizmo {
class EditUpdEvent;
}


namespace pageedit {

class PageEditWidget2D;
class PageEditStrategy;
class ExternalItemEditUpdEvent;

typedef hmibase::util::ObjectAccessor<PageEditWidget2D> PageWidgetAccessor;


/*****************************************************************************/
class PageEditController2DData : public hmibase::widget::WidgetControllerData
{
      FEATSTD_TYPEDEF_BASE(hmibase::widget::WidgetControllerData);

   public:
      CANDERA_RTTI_DECLARATION(PageEditController2DData);

      PageEditController2DData() {}
};


/*****************************************************************************/
/* Abstract class used for button group controllers.
*/
/*****************************************************************************/
class PageEditController2D : public hmibase::widget::WidgetController
{
      FEATSTD_TYPEDEF_BASE(hmibase::widget::WidgetController);

   public:
      CANDERA_RTTI_DECLARATION(PageEditController2D);

      PageEditController2D() {}

      virtual bool SearchItems(PageEditWidget2D& pageEdit, std::vector<ItemWidget*>& items) = 0;
      virtual void ValidateCellSize(PageEditWidget2D& pageEdit, Page& page) = 0;
      virtual void ProcessItemCellsConfig(PageEditWidget2D& pageEdit, Page& page) = 0;
      virtual void CollectItems(PageEditWidget2D& pageEdit, Page& page) = 0;
      virtual void SetItemsBounds(PageEditWidget2D& pageEdit, Page& page, bool useEditingCells) = 0;
      virtual void SetEditingCellsNodeBounds(PageEditWidget2D& pageEdit, Page& page) = 0;
      virtual unsigned int GetMovementTimerTimeout(PageEditWidget2D& pageEdit) const = 0;

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(PageEditController2D);
};


/*****************************************************************************/
class DefaultPageEditController2DData : public PageEditController2DData
{
      FEATSTD_TYPEDEF_BASE(PageEditController2DData);

   public:
      CANDERA_RTTI_DECLARATION(DefaultPageEditController2DData);

      Page::SharedPointer PageData;
};


/*****************************************************************************/
class DefaultPageEditController2D : public PageEditController2D
{
      FEATSTD_TYPEDEF_BASE(PageEditController2D);

   public:
      CANDERA_RTTI_DECLARATION(DefaultPageEditController2D);

      DefaultPageEditController2D();
      virtual ~DefaultPageEditController2D();

      /* Singleton instance. */
      static DefaultPageEditController2D& GetInstance()
      {
         static DefaultPageEditController2D _instance;
         return _instance;
      }

      //overrides from WidgetController
      virtual hmibase::widget::WidgetControllerData* CreateData(DelegateWidget&)  override;
      virtual void Attach(DelegateWidget& delegateWidget) override;
      virtual void Detach(DelegateWidget& delegateWidget) override;

      virtual void OnChanged(DelegateWidget& delegateWidget, FeatStd::UInt32 propertyId) override;
      virtual bool OnEvent(DelegateWidget& delegateWidget, const hmibase::widget::WidgetControllerEvent& e) override;
      virtual void Update(DelegateWidget& delegateWidget) override;

      //overrides from PageEditController2D
      virtual bool SearchItems(PageEditWidget2D& pageEdit, std::vector<ItemWidget*>& items) override;
      virtual void ValidateCellSize(PageEditWidget2D& pageEdit, Page& page) override;
      virtual void ProcessItemCellsConfig(PageEditWidget2D& pageEdit, Page& page) override;
      virtual void CollectItems(PageEditWidget2D& pageEdit, Page& page) override;
      virtual void SetItemsBounds(PageEditWidget2D& pageEdit, Page& page, bool useEditingCells) override;
      virtual void SetEditingCellsNodeBounds(PageEditWidget2D& pageEdit, Page& page) override;

      virtual unsigned int GetMovementTimerTimeout(PageEditWidget2D& pageEdit) const;
      void SetMovementTimerTimeout(unsigned int timeout);

   protected:
      virtual void SetItemBounds(PageEditWidget2D& pageEdit, Page& page, Item& itemInfo, const CellRect& cellRect);

      void UnregisterPage(DelegateWidget& delegateWidget);

      unsigned int _movementTimerTimeout;

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(DefaultPageEditController2D);
};


/*****************************************************************************/
//to be removed!
class ExternalItemEditUpdEvent : public hmibase::widget::WidgetControllerEvent
{
      FEATSTD_TYPEDEF_BASE(hmibase::widget::WidgetControllerEvent);

   public:
      CANDERA_RTTI_DECLARATION(ExternalItemEditUpdEvent);

      ExternalItemEditUpdEvent(PageEditWidget2D* owner, const hmibase::widget::gizmo::EditUpdEvent& itemEvent, const Cell& itemSpan)
         : _owner(owner), _itemEvent(itemEvent), _itemSpan(itemSpan)
      {
      }

      ~ExternalItemEditUpdEvent()
      {
         _owner = NULL;
      }

      PageEditWidget2D* GetOwner() const
      {
         return _owner;
      }

      const hmibase::widget::gizmo::EditUpdEvent& GetItemEvent() const
      {
         return _itemEvent;
      }

      const Cell& GetItemSpan() const
      {
         return _itemSpan;
      }

   private:
      ExternalItemEditUpdEvent(const ExternalItemEditUpdEvent&);
      ExternalItemEditUpdEvent& operator =(const ExternalItemEditUpdEvent&);

      PageEditWidget2D* _owner;
      const hmibase::widget::gizmo::EditUpdEvent& _itemEvent;
      Cell _itemSpan;
};


}
}


}
