/* ***************************************************************************************
* FILE:          PageEditCell.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  PageEditCell.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "widget2D_std_if.h"
#include "PageEditCell.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_PAGEEDIT
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/PageEditCell.cpp.trc.h"
#endif


namespace hmibase {
namespace widget {
namespace pageedit {


const PageItemIndex PageItemIndex::Default;

/*****************************************************************************/
::std::ostream& operator<<(::std::ostream& out, const Cell& value)
{
   return out << value.Column << ',' << value.Row;
}


/*****************************************************************************/
::std::ostream& operator<<(::std::ostream& out, const CellRect& value)
{
   return out << value.TopLeft << ',' << value.Span;
}


/*****************************************************************************/
::std::ostream& operator<<(::std::ostream& out, const PageItemIndex& value)
{
   if (value.ItemIndex == -1)
   {
      return out << "   ";
   }
   else
   {
      return out << value.PageIndex << '-' << value.ItemIndex;
   }
}


/*****************************************************************************/
::std::ostream& operator<<(::std::ostream& out, const CellGrid& value)
{
   for (CellIndexType row = 0; row < value.GetRowCount(); ++row)
   {
      //if (row != 0)
      {
         //out << '|';
         out << '\n';
      }
      for (CellIndexType column = 0; column < value.GetColumnCount(); ++column)
      {
         if (column != 0)
         {
            out << ',';
         }
         out << value.GetCellData(column, row);
      }
   }
   return out;
}


}
}


}
