/* ***************************************************************************************
* FILE:          OverlayLayouterWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  OverlayLayouterWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(OverlayLayouterWidget2D_H)
#define OverlayLayouterWidget2D_H

#include "Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h"
#include "Widgets/2D/OverlayLayouter/generated/OverlayLayouterWidget2DBase.h"

class OverlayLayouterWidget2D : public OverlayLayouterWidget2DBase
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(OverlayLayouterWidget2D, OverlayLayouterWidget2DBase);

      OverlayLayouterWidget2D();

      virtual ~OverlayLayouterWidget2D();

      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

      virtual void Update();

      CdaWidget2DDef(OverlayLayouterWidget2D, OverlayLayouterWidget2DBase)
      CdaProperties() //Start of properties
      CdaPropertiesEnd() // End of properties
      CdaWidgetDefEnd()

   protected:
      virtual void OnNodeChanged();

   private:
      Candera::Node2D* _layoutNode;
      Candera::Layouter* _originalLayouter;
};


#endif
