/* ***************************************************************************************
* FILE:          OPSWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  OPSWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef HTC_OPSWIDGET_2D_H
#define HTC_OPSWIDGET_2D_H

#include "Widgets/2D/OPS/generated/OPSWidgetBase.h"
#include "Widgets/2D/Animation/AnimationHelperInterface.h"

enum enSensor
{
   enUnknown = 0,
   enFront = 1,
   enRear = 2,
   enLeft = 3,
   enRight = 4
};


enum enImageMode
{
   enUnknownMode = 0,
   enActiveRed = 1,
   enActiveYellow = 2,
   enGrey = 3,
   enBackground = 4,
   enHatched = 5,
   enNotAvailable = 6,
   enNotInitilized = 7,
   enWarning = 8
};


enum enRTAState
{
   enRTAOff = 0,
   enRTAGrey = 1,
   enRTAYellow = 2,
   enRTARed = 3,
   enRTAError = 4
};


/*
0xF	- Error (used to decide to show the error icon)
0xE	- Not Initialised		( No Background image display or segment image display for the particular sector )
0xD	- Temp not available (used to decide to show the Mud or Ice detected icon)
0x0	- No Warning		(BackGround Image displayed)
0x1	- Low 	(Grey)
0x2	- Medium	(Yellow)
0X3	- Hard (Red)
*/
enum enStatusValue
{
   enNoWarning = 0x0,
   enLowWarning = 0x1,
   enMediumWarning = 0x2,
   enHardWarning = 0x3,
   enNotAvail = 0xD,
   enNotInit = 0xE,
   enError = 0xF
};


//namespace UnderConstruction {


class OPSWidget2D : public OPSWidgetBase
{
   public:
      OPSWidget2D();
      virtual ~OPSWidget2D();

      CGI_WIDGET_RTTI_DECLARATION(OPSWidget2D, OPSWidgetBase);

      virtual void InitWidget();
      void Update1();
      void Update2();
      virtual void Update(); // override

      void vSetImage(Candera::RenderNode* pRenderNode, bool bFlag);
      Candera::MemoryManagement::SharedPointer<Candera::Effect2D> m_bitmapBrush;
      Candera::MemoryManagement::SharedPointer<Candera::BitmapImage2D> m_pBitmapImg;
      FeatStd::Internal::Vector<bool> m_lstbSensorHatchedData;
      Courier::ListPropertyType<bool> m_lstbHatchedValProperty;
      FeatStd::Internal::Vector<bool> m_lstbSensorScannedData;
      Courier::ListPropertyType<bool> m_lstbScannedValProperty;

      void vHandleOPSDisplayModeUpdate();
      void vHandleSensorFieldHatched();
      void vHandleSensorFieldScanned();
      void vHandleOPSWidgetTypeUpdate();
      void vHandleTrailerConnectedUpdate();
      void vHandleVehicleTypeUpdate();
      void vHandleSensorsAvailableUpdate(Candera::UInt8 u8SenNo);
      void vHandleSensorsSegmentValuesUpdate();
      void vHandleSensorFieldBlink();
      void vHandleBlinkInterval();
      void vHandleLeftRTAUpdate();
      void vHandleRightRTAUpdate();
      void vRequestSensorsAvailability();
      void vRequestsensorssegmentvalue();
      void vRequestSegmentPreDefinedDistance();
      void vRequestStatusValuelist();
      void vDisplayAllImgs();
      void vDisplayCarImg();
      void vDisplayTrailerImg(bool bFlag);
      void vDisplayFrontSensorSectorImgs();
      void vDisplayFnsForSectorBgImg(Candera::UInt8 u8SecNo, bool bFlag);
      void vSetSensorIndex(Candera::enOPSDisplayMode);
      enSensor enGetSensorType(Candera::UInt8 u8SecNo);
      void vGetStartAndEndIndex(enSensor enSensorType, Candera::UInt8* u8StartIndex, Candera::UInt8* u8EndIndex, Candera::UInt8* u8WarningIndex)const;
      void vDisplayFnsForRearSensorSectorImgs(bool bFlag);
      void vRemoveAllRearSensorImgs();
      void vRemoveSectorNodeImgs(Candera::UInt8 u8Index);
      void vSubRemoveAllImgs(Candera::Node2D*);
      void vRemoveAllImgs();
      void vRemoveAllNodeAssociatedImgs(Candera::Node2D*);
      void vRemoveHatchedNodeAssociatedImgs(Candera::Node2D*);
      void vDisplayRearSensorSectorImgs();
      void vDisplayLeftSensorSectorImgs();
      void vDisplayRightSensorSectorImgs();
      void vDisplayBackgroundImg(Candera::UInt8 u8CurrentSec, bool bHatchedVal, bool bDisplayflag, bool bScannedVal);
      void vDisplayBackgroundErrImg(Candera::UInt8 u8CurrentSec, bool bDisplayflag);
      void vRemoveSensorAllSectorSegImgsAndDisplayWarning(Candera::UInt8 u8StartIndex, Candera::UInt8 u8EndIndex, Candera::UInt8 u8WarningIndex);
      void vDisplaySensorSectorSegImgs(enSensor enSenType);
      void vDisplaySegmentImg();
      void vGetActiveSegmentIndex(Candera::UInt8 u8ActVal, Candera::UInt8 u8TotalAvailPreValue,
                                  bool* bSegmentActive, Candera::UInt8* u8ActiveSegIndex);
      void vGetActiveColorPQ(Candera::UInt8 u8IxNo, enImageMode* enActiveColor);
      void vGetActiveColor(Candera::UInt8 u8SecNo, enImageMode* enActColor);
      void vDisplayActiveSegments(Candera::UInt8 u8SecNo, Candera::UInt8 u8TotalAvailPreValue, bool bSegmentActive, Candera::UInt8 u8ActiveSegIndex);
      void vSegmentValComparefns(Candera::UInt8 u8ActVal, Candera::UInt8 u8SecNo);
      void vDisplayFnsforRTA(Candera::UInt8 u8State, Candera::UInt8 u8Distance, bool bIsRightSide);
      void vDisplayRTAImg(enRTAState enActive, enRTAState enDeactive1, enRTAState enDeactive2, bool bIsRightSide);
      void vGetPreviousSecDetails(Candera::UInt8* u8PreviousActSeg, enImageMode* enPreviousActMode, bool* bSegHatchedInfo, bool* bSegScannedInfo);
      void vRemovePreviousActImgs(Candera::UInt8 u8WarningIx);
      void vRemoveAlreadyDisplayedImg(Candera::UInt8 u8SecNo, Candera::UInt8 u8SegNo, enImageMode enMode, bool bHatchedVal);
      void vDisplayCurrentActImgs(Candera::UInt8 u8SegNo, enImageMode enMode, Candera::UInt8 u8StartIndex, Candera::UInt8 u8EndIndex, Candera::UInt8 u8WarningIndex);
      void vDisplaySegmentFinalImg(Candera::UInt8 u8SegNo, enImageMode enMode);
      void vDisplayAllFromActiveSegments(Candera::UInt8 u8SecNo, Candera::UInt8 u8SegNo, Candera::UInt8 u8ChildCount, enImageMode enMode);
      Candera::Node2D* GetBasicNode(Candera::enOPSDisplayMode) const;
      Candera::Node2D* GetCarNode() const;
      Candera::RenderNode* GetNthCarImgNode() const;
      Candera::Node2D* GetMainSecNode() const;
      Candera::Node2D* GetImageTypeNode(Candera::UInt8 u8SecNodeNo, enImageMode enMode, bool bHatchedVal) const;
      Candera::Node2D* GetSenErrorWarningNode() const;
      Candera::RenderNode* GetSenErrorWarningImg(Candera::UInt8 u8Cnt) const;
      Candera::Node2D* GetSecNode(Candera::UInt8 u8SecNo, bool bHatchedVal) const;
      Candera::Node2D* GetRTANode() const;
      Candera::RenderNode* GetRTAImgNode(bool bIsRight, enRTAState enState) const;
      Candera::RenderNode* GetTrailerImgNode() const;
      Candera::RenderNode* GetBackgroundImgNode(Candera::UInt8 u8SectorNo, enImageMode enMode, bool bHatchedval, bool bFlag, bool bScannedVal) const;
      Candera::RenderNode* GetNthSegmentNode(Candera::UInt8 u8SecNo, Candera::UInt8 u8SegmentNo, enImageMode enMode, bool bHatchedVal) const;
      void vHandleBlinkAnimationOfNode(Candera::RenderNode* RSegNode, Candera::UInt8 u8SecNo, enImageMode enMode);
      void OnParentViewActivate(bool enable);
      void stopExistingAnimations();

   protected:
      virtual void OnAnimationTimeDispatcherChanged();
      void OnChanged1(::Courier::UInt32);
      void OnChanged2(::Courier::UInt32);
      void OnChanged(::Courier::UInt32);

   private:

      Candera::UInt8 m_u8CurrentSector;

      FeatStd::Internal::Vector<bool> m_lstbSensorData;
      Courier::ListPropertyType<bool> m_lstbSensorsAvailProperty;

      FeatStd::Internal::Vector<Courier::UInt16> m_lstu16SegValData;
      Courier::ListPropertyType<Courier::UInt16> m_lstu16SegValProperty;

      FeatStd::Internal::Vector<Courier::UInt16> m_lstu16PreValData;
      Courier::ListPropertyType<Courier::UInt16> m_lstu16PreValProperty;

      FeatStd::Internal::Vector<Courier::UInt16> m_lstu16StatusData;
      Courier::ListPropertyType<Courier::UInt16> m_lstu16StatusProperty;
      FeatStd::Internal::Vector<bool> m_lstbSensorBlinkData;
      Courier::ListPropertyType<bool> m_lstbSensorBlinkProperty;
      FeatStd::Internal::Vector<Courier::UInt16> m_lstu16BlinkIntervalData;
      Courier::ListPropertyType<Courier::UInt16> m_lstu16BlinkIntervalProperty;

      void vAddNewSensorData(FeatStd::Internal::Vector<bool>& Sendata, FeatStd::UInt16 u16Index, const bool& DataEntry);

      void vAddNewSegmnetData(FeatStd::Internal::Vector<Courier::UInt16>& Segdata, FeatStd::UInt16 u16Index, const Courier::UInt16& DataEntry);

      void vAddNewHatchedData(FeatStd::Internal::Vector<bool>& Segdata, FeatStd::UInt16 u16Index, const bool& DataEntry);
      void vAddNewScannedData(FeatStd::Internal::Vector<bool>& Segdata, FeatStd::UInt16 u16Index, const bool& DataEntry);
      void vAddNewPreValData(FeatStd::Internal::Vector<Courier::UInt16>& PreSegdata, FeatStd::UInt16 u16Index, const Courier::UInt16& DataEntry);

      void vAddNewStatusData(FeatStd::Internal::Vector<Courier::UInt16>& Statusdata, FeatStd::UInt16 u16Index, const Courier::UInt16& DataEntry);
      void vAddNewSensorFieldBlinkData(FeatStd::Internal::Vector<bool>& Segdata, FeatStd::UInt16 u16Index, const bool& DataEntry);
      void vAddNewSensorFieldBlinkIntervalData(FeatStd::Internal::Vector<Courier::UInt16>& Segdata, FeatStd::UInt16 u16Index, const Courier::UInt16& DataEntry);

      class ListEventHandler
      {
         public:
            OPSWidget2D* m_pWidget;
            void OnHatchedUpdateListEvent(const Courier::ListEvent& listEvent);
            void OnSensorsAvailabilityListEvent(const Courier::ListEvent& listEvent);
            void OnSegmentUpdateListEvent(const Courier::ListEvent& listEvent);
            void OnScannedUpdateListEvent(const Courier::ListEvent& listEvent);
            void OnSegmentPreValUpdateListEvent(const Courier::ListEvent& listEvent);
            void OnStatusUpdateListEvent(const Courier::ListEvent& listEvent);
            void OnSensorFieldBlinkListEvent(const Courier::ListEvent& listEvent);
            void OnBlinkIntervalListEvent(const Courier::ListEvent& listEvent);
      };
      friend class ListEventHandler;

      ListEventHandler _listEventHandler;

      bool m_bOPSWidgetTypeUpdate;
      bool m_bDisplayModeUpdate;
      bool m_bTrailerConnected;
      bool m_bVehicleType;
      bool m_bSensorsAvailable;
      bool m_bSensorsSegmentValue;
      bool m_bSegmentPreDefinedDistance;
      bool m_bStatusValueUpdate;
      bool m_bLeftRTASensorLevel;
      bool m_bRightRTASensorLevel;
      bool m_bLeftRTADistanceValue;
      bool m_bRightRTADistanceValue;
      bool m_bSensorFieldHatched;
      bool m_bSensorFieldScanned;
      bool m_bSensorFieldBlink;
      bool m_bBlinkIntervalValue;
      Candera::enOPSDisplayMode m_enPreviousDismode;
      bool m_bImgRemoved;
      Candera::UInt8 m_u8StartIxFrontSen;
      Candera::UInt8 m_u8EndIxFrontSen;
      Candera::UInt8 m_u8StartIxRearSen;
      Candera::UInt8 m_u8EndIxRearSen;
      Candera::UInt8 m_u8StartIxLeftSen;
      Candera::UInt8 m_u8EndIxLeftSen;
      Candera::UInt8 m_u8StartIxRightSen;
      Candera::UInt8 m_u8EndIxRightSen;
      bool _isInvalid;
      //Candera::UInt8 m_u8aLastDisplayedSegInfo[16][2];
      struct prevseginfo
      {
         std::map<Candera::UInt8, Candera::UInt8> prevSegVal;
         bool prevHatchedVal;
         bool prevScannedVal;
      };
      std::map < Candera::UInt8, prevseginfo> m_u8MapLastDisplayedSegInfo;

      AnimationHelperInterface* _animationHelperInterface;
      CdaWidget2DDef(/*UnderConstruction::*/OPSWidget2D, OPSWidgetBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()
};


#endif
