/* ***************************************************************************************
* FILE:          MarkerWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  MarkerWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(MarkerWidget2D_H)
#define MarkerWidget2D_H

#include <Widgets/2D/Marker/generated/MarkerWidget2DBase.h>
#include <Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h>
#include <Widgets/utils/WidgetFunctors.h>

typedef hmibase::widget::utils::ComplexId4<unsigned int> MarkerIdType;
typedef hmibase::widget::utils::functors::MatchesComplexId4<unsigned int> MarkerIdFilter;


/*****************************************************************************/
class MarkerWidget2D : public MarkerWidget2DBase
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(MarkerWidget2D, MarkerWidget2DBase);

      MarkerWidget2D();

      virtual ~MarkerWidget2D();

      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

      MarkerIdType getMarkerId() const;

      /* Searches within the specified scene context for a marker widget which matches a filter.
      * Get the scene context of a view by calling view.ToViewScene2D()->GetScene2DContext().
      * Get the scene context of the view in which a widget is contained by calling hmibase::widget::utils::MessageUtils::getSceneContext(&widget).
      */
      static MarkerWidget2D* findMarker(Candera::Scene2DContext* sceneContext, const MarkerIdFilter& markerFilter);

      /* Searches within the specified scene context for a marker widget which matches a filter and is linked to a node being a descendant of the specified one.
      * Get the scene context of a view by calling view.ToViewScene2D()->GetScene2DContext().
      * Get the scene context of the view in which a widget is contained by calling hmibase::widget::utils::MessageUtils::getSceneContext(&widget).
      */
      static MarkerWidget2D* findDescendantMarker(Candera::Scene2DContext* sceneContext, Candera::Node2D& node, const MarkerIdFilter& markerFilter);

      CdaWidget2DDef(MarkerWidget2D, MarkerWidget2DBase)
      CdaProperties() //Start of properties
      CdaPropertiesEnd() // End of properties
      CdaWidgetDefEnd()
};


#endif
