/* ***************************************************************************************
* FILE:          ListItemAnimationMarkerWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ListItemAnimationMarkerWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "Widgets/2D/Common/ListItemAnimationDynamicPropertyHost.h"
#include "ListItemAnimationMarkerWidget2D.h"


CGI_WIDGET_RTTI_DEFINITION(ListItemAnimationMarkerWidget2D);


ListItemAnimationMarkerWidget2D::ListItemAnimationMarkerWidget2D() :
   _animation(0)
{
}


ListItemAnimationMarkerWidget2D::~ListItemAnimationMarkerWidget2D()
{
   _animation = AnimationType(0);
}


bool ListItemAnimationMarkerWidget2D::CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap)
{
   bool cloned(Base::CloneFrom(originalWidget, controlTemplateMap));

   return cloned;
}


void ListItemAnimationMarkerWidget2D::OnChanged(Courier::UInt32 propertyId)
{
   Base::OnChanged(propertyId);

   const AnimationType& newAnimation(GetAnimation());
   const AnimationType& oldAnimation(_animation);

   switch (propertyId)
   {
      case AnimationPropertyId:
         _animation = newAnimation;
      // fall to property type

      case AnimationTypePropertyId:
         if (!oldAnimation.PointsToNull())
         {
            ListItemAnimationDynamicPropertyHost::SetListItemAnimationType(oldAnimation, LIANone);
         }

         if (!newAnimation.PointsToNull())
         {
            ListItemAnimationDynamicPropertyHost::SetListItemAnimationType(newAnimation, GetAnimationType());
         }
         break;

      default:
         //do nothing
         break;
   }
}
