/* ***************************************************************************************
* FILE:          ListFocusControllerWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ListFocusControllerWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "ListFocusControllerWidget2D.h"
#include "Widgets/2D/List/ListWidget2D.h"
#include "Focus/FCommon.h"
#include "Focus/FConfigInfo.h"
#include "Focus/FController.h"
#include "Focus/FDataSet.h"
#include "Focus/FData.h"
#include "Focus/FActiveViewGroup.h"
#include "Focus/FManager.h"
#include "Widgets/2D/WidgetFinder2D.h"
#include "Widgets/2D/Focus/FocusGroupWidget2D.h"


#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_LIST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/ListFocusControllerWidget2D.cpp.trc.h"
#endif


CGI_WIDGET_RTTI_DEFINITION(ListFocusControllerWidget2D);


ListFocusControllerWidget2D::ListFocusControllerWidget2D(): Base(),
   _listWidget(NULL)
{
   //SetFocusableStatus(true);
}


ListFocusControllerWidget2D::~ListFocusControllerWidget2D()
{
   _listWidget = NULL;
}


Focus::FController*& ListFocusControllerWidget2D::focusController()
{
   static Focus::FController* controller = NULL;
   return controller;
}


void ListFocusControllerWidget2D::Update()
{
   if (_listWidget == NULL)
   {
      updateListWidget();
   }
}


void ListFocusControllerWidget2D::updateListWidget()
{
   if ((_listWidget == NULL) && (GetNode() != NULL))
   {
      _listWidget = WidgetFinder::FindAncestorWidget<ListWidget2D>(this);
   }
}


void ListFocusControllerWidget2D::OnNodeChanged()
{
   _listWidget = NULL;
   Invalidate();
}


void ListFocusControllerWidget2D::RegisterToFocusManagerImpl(Focus::FManager& focusManager, Focus::FSession& session, Focus::FWidgetConfig& handle)
{
   (void)handle;
   if ((focusController() != NULL) && (_listWidget != NULL) && (GetParentView() != NULL))
   {
      Focus::FWidgetConfig* listHandle = focusManager.getHandle(GetParentView()->GetId(), _listWidget->GetLegacyName());
      if (listHandle != NULL)
      {
         focusController()->configureWidget(session, *listHandle, *_listWidget);
      }
   }
}


//static bool IsListRenderingEnabled(const ListWidget2D& listWidget)
//{
//   return ((listWidget.GetItemsNode() != NULL) && (listWidget.GetItemsNode()->IsEffectiveRenderingEnabled())) ||
//          ((listWidget.GetNode() != NULL) && (listWidget.GetNode()->IsEffectiveRenderingEnabled()));
//}


static bool DefaultListChangeStrategy(ListWidget2D& listWidget, const ListChangeMsg& msg, bool force)
{
   int steps = msg.GetValue();
   if ((steps > 0) && ((msg.GetListChangeType() == ListChangeUp) || (msg.GetListChangeType() == ListChangePageUp)))
   {
      steps = -steps;
   }
   int start = static_cast<int>(listWidget.GetStartIndex());
   FeatStd::Int32 newStart = start;
   int pageSize = static_cast<int>(listWidget.GetEffectiveNumberOfItems());
   int maxPosition = static_cast<int>(listWidget.GetMaxPosition());
   int totalItemCount = (listWidget.GetDataWrapper().IsDataAvailable() ? static_cast<int>(listWidget.GetDataWrapper().GetVirtualListSize()) : 0);
   const PagesInfo& pagesInfo = listWidget.GetPagesInfo();
   const bool circular = listWidget.IsCircular();

   ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "DefaultListChangeStrategy request listId=%d, steps=%d, action=%d, start=%d, maxPos=%d, total=%d, circular=%d",
                       listWidget.GetListId(), steps, msg.GetListChangeType(), start, maxPosition, totalItemCount, circular));

   //if less items than one page, show first item
   if ((totalItemCount == 0) || (pageSize >= totalItemCount && !circular))
   {
      newStart = 0;
   }
   else
   {
      switch (msg.GetListChangeType())
      {
         case ListChangeSet:
            newStart = steps;
            break;

         case ListChangeUp:
         case ListChangeDown:
            newStart = start + steps;
            break;

         case ListChangePageUp:
            pagesInfo.RetrieveStartIndexOfPage(steps, newStart);
            break;

         case ListChangePageDown:
            pagesInfo.RetrieveStartIndexOfPage(steps, newStart);
            break;

         default:
            break;
      }
   }

   ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "DefaultListChangeStrategy actual listId=%d, start=%d", listWidget.GetListId(), newStart));

   //hide the focus
   //if (Focus::FManager::getInstance().getActivityTimer() != NULL)
   //{
   //   Focus::FManager::getInstance().getActivityTimer()->stop();
   //}
   //Focus::FManager::getInstance().hideFocus();
   listWidget.CheckAndSetFocusedIndex(-1);

   if ((newStart != start) || force)
   {
      listWidget.RequestImmediatePositioning(true);
      if (force)
      {
         listWidget.SetStartIndex(newStart);
      }
      else
      {
         listWidget.CheckAndSetStartIndex(newStart);
      }
      listWidget.Invalidate();
   }

   return true;
}


ListWidget2D::FocusStrategy& ListWidget2D::FlexListWidget2DGetFocusStrategy()
{
   static ListWidget2D::FocusStrategy g_focusStrategy = DefaultListChangeStrategy;
   return g_focusStrategy;
}


Focus::FControllerSetId ListWidget2D::_defaultFocusControllers = 0;

void ListWidget2D::SetDefaultFocusControllers(Focus::FControllerSetId setId)
{
   _defaultFocusControllers = setId;
}


void ListWidget2D::RegisterToFocusManagerImpl(Focus::FManager& focusManager, Focus::FSession& session, Focus::FWidgetConfig& handle)
{
   Base::RegisterToFocusManagerImpl(focusManager, session, handle);

   //configure default controllers if there are not specific ones for this widget
   if ((GetFocusControllerSet() <= 0) && (_defaultFocusControllers > 0))
   {
      ConfigureFocusControllers(*this, focusManager, session, handle, _defaultFocusControllers);

      Focus::FWidgetData* widgetData = handle.getData<Focus::FWidgetData>();
      if (widgetData != NULL)
      {
         widgetData->ControllerSetId = static_cast<Focus::FControllerSetId>(_defaultFocusControllers);
      }
   }

   Focus::FListData* listData = handle.getOrCreateData<Focus::FListData>();
   if (listData != NULL)
   {
      listData->ListId = static_cast<int>(GetListId());
      listData->FirstVisibleIndex = static_cast<int>(GetStartIndex());
      listData->VisibleItemCount = static_cast<int>(GetEffectiveNumberOfItems());

      int totalItemCount = (GetDataWrapper().IsDataAvailable() ? static_cast<int>(GetDataWrapper().GetVirtualListSize()) : 0);
      listData->TotalItemCount = static_cast<int>(totalItemCount);
   }

   FocusGroupBase::registerGroupToFocusManager(focusManager, session, handle);
}
