/* ***************************************************************************************
* FILE:          SwipingStateChecker.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SwipingStateChecker is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(SwipingStateChecker_H)
#define SwipingStateChecker_H

class SwipingStateChecker
{
   public:
      virtual ~SwipingStateChecker() { }

      virtual bool IsIdle() const = 0;
      virtual bool IsTouched() const = 0;
      virtual bool IsFocused() const = 0;
      virtual bool IsScrolling() const = 0;
      virtual bool WasScrolling() const = 0;
};


#endif
