/* ***************************************************************************************
* FILE:          SwipingListener.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SwipingListener is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(SwipingListener_H)
#define SwipingListener_H

#include <CanderaPlatform/OS/CanderaTypes.h>
#include <Candera/System/Mathematics/Vector2.h>
#include <Widgets/2D/List/generated/ListEnums.h>

namespace SwipingState {
enum Enum
{
   Idle = ListIdle,
   Touched = ListTouched,
   Focused = ListFocused,
   Scrolling = ListScrolling,
   Swiping = ListSwiping
};


}

class SwipingListener
{
   public:
      virtual ~SwipingListener() { }

      /**
       * Called when the gesture begins, typically before scrolling; if scrolling is not configured, then
       * it will be called before swiping
       */
      virtual void OnGestureBegin(const Candera::Vector2& /*position*/) { }

      /**
       * Called when swiping starts. Should return true if the Swiping state should be activated
       * or false if Idle should be the next state
       */
      virtual bool OnSwipeStart(const Candera::Float /*estimatedDistance*/)
      {
         return true;
      }

      /**
       * Called while swiping. Should return true if the Swiping state should be maintained
       * or false if Idle should be the next state
       */
      virtual bool OnSwipe(const Candera::Float /*movementDistance*/, const bool /*forward*/)
      {
         return true;
      }

      /**
       * Called when swiping ends. Should return true if the next state(Idle or Scrolling) should be activated
       * or false if Idle should be the next state
       */
      virtual bool OnSwipeEnd()
      {
         return true;
      }

      /**
       * Called when scrolling starts. Should return true if the Scrolling state should be activated
       * or false if Idle should be the next state
       */
      virtual bool OnScrollStart(const Candera::Vector2& /*pos*/)
      {
         return true;
      }

      /**
       * Called while scrolling. Should return true if the Scrolling state should be maintained
       * or false if Idle should be the next state
       */
      virtual bool OnScroll(const Candera::Float /*movementDistance*/, const bool /*forward*/)
      {
         return true;
      }

      /**
       * Called when scrolling ends. Should return true if the next state(Idle or Swiping) should be activated
       * or false if Idle should be the next state
       */
      virtual bool OnScrollEnd(const Candera::Vector2& /*pos*/)
      {
         return true;
      }

      virtual void OnStateChanged(const SwipingState::Enum /*state*/) { };
};


#endif
