/* ***************************************************************************************
* FILE:          Swiper.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Swiper is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef Flex_Swiper_H
#define Flex_Swiper_H

#include <FeatStd/Platform/Types.h>

#include "SwipingStateChecker.h"
#include "Widgets/2D/List/Content/ItemSizesContainer.h"
#include "PositioningHandler.h"
#include <TouchGestures/GestureBasetypes.h>
#include <Widgets/2D/List/Swiping/SwipingAdjuster.h>
#include <Courier/Foundation/FoundationMsgs.h>
#include <Widgets/2D/List/Swiping/SwipingListener.h>
#include <Widgets/2D/List/Swiping/Normalizer.h>
#include <Widgets/2D/List/Swiping/OverscrollMover.h>

class FlexScrollable;

class Swiper : public ItemSizesContainer, public SwipingAdjuster
{
   public:
      Swiper();
      virtual ~Swiper();

      void Init(PositioningHandler* positioningHandler, FlexScrollable* scrollable);

      /**
       * @return true if the swipe was done succesfully; false otherwise
       */
      bool SwipeList(FeatStd::Float movingDistance, bool forward);

      /**
       * @return true if scrolling was done succesfully; false otherwise
       */
      bool ScrollList(FeatStd::Float movingDistance, bool forward);

      virtual void SetItemsSizes(const ItemSizesContainer::SizesVector& val) override;
      virtual const ItemSizesContainer::SizesVector& GetItemsSizes() const override;
      virtual Courier::Float GetTotalSize() const override;

      void SetNormalizer(Normalizer* normalizer);
      void SetOverscrollMover(OverscrollMover* mover);

   private:
      // private copy constructor and assignment operator, not intended to be called
      Swiper(const Swiper& other);
      Swiper& operator =(const Swiper& other);

      /**
       * Moves the list by the amount specified by movindDistance and updates the startIndex
       * @return true if moveing is successfull; false otherwise
       */
      bool MoveList(FeatStd::Float movingDistance, bool forward);

      void Overscroll(FeatStd::Float movingDistance, bool forward);

      /**
       * limits corretctedPosition to interval [0; upperLimit]
       */
      bool LimitPosition(const FeatStd::Float upperLimit, FeatStd::Float& correctedPosition);

      virtual FeatStd::Float AdjustInitialSwipedDistance(FeatStd::Float calculatedSwipeDistance);
      virtual FeatStd::Float AdjustSwipedDistance(FeatStd::Float calculatedSwipeDistance);
      FeatStd::Float AdjustDistance(FeatStd::Float calculatedSwipeDistance, bool overscroll);

      PositioningHandler* _positioningHandler;
      FlexScrollable* _scrollable;
      FeatStd::Float _swipingTarget;
      ItemSizesContainer::SizesVector _itemSizes;
      FeatStd::Float _previousAdjustedPosition;
      Normalizer* _normalizer;
      OverscrollMover* _overscrollMover;
      bool _swipeStartedWithOverscroll;
      FeatStd::Float _swipingStartOverscroll;
};


#endif
