/* ***************************************************************************************
* FILE:          PositioningHandler.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  PositioningHandler is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(PositioningHandler_H)
#define PositioningHandler_H

#include "TargetPositioner.h"
#include <CanderaPlatform/OS/CanderaTypes.h>


class PositioningHandler : public TargetPositioner
{
   public:
      virtual ~PositioningHandler() { }

      virtual FeatStd::Float GetCurrentPosition() const = 0;
      virtual FeatStd::Float GetMaximumPosition() = 0;
      virtual FeatStd::Float GetMaximumSwipingPosition() const = 0;
      virtual bool IsCircular() const = 0;

      virtual void SetCurrentPosition(FeatStd::Float val) = 0;
      virtual void ResetMaximumPositions() = 0;
};


#endif
