/* ***************************************************************************************
* FILE:          PageSwipingBehaviorInfo.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  PageSwipingBehaviorInfo is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef PageSwipingBehaviorInfo_H
#define PageSwipingBehaviorInfo_H

#include <FeatStd/Platform/Types.h>
#include <Widgets/2D/List/Content/Adders/OrientationOperator.h>

class PageSwipingBehaviorInfo
{
   public:
      virtual ~PageSwipingBehaviorInfo() { }

      virtual const Candera::Vector2 GetVisibleArea() const = 0;
      virtual const FeatStd::Float GetScrollOffsetPercentage() const = 0;

      bool IsThresholdMet(const OrientationOperator& orientationOperator, FeatStd::Float distance) const
      {
         return (distance >= (orientationOperator.GetVectorComponent(GetVisibleArea()) * GetScrollOffsetPercentage()));
      }
};


#endif
