/* ***************************************************************************************
* FILE:          OverscrollFunction.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  OverscrollFunction is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef OverscrollFunction_H
#define OverscrollFunction_H

#include <FeatStd/Platform/Types.h>
#include <Widgets/2D/List//generated/ListEnums.h>

class OverscrollFunction
{
   public:
      virtual ~OverscrollFunction() { }

      virtual bool IsOnDragEnabled() = 0;

      virtual bool IsOnSwipeEnabled() = 0;

      /**
       * @param viewportFraction - the part per mille of the fraction that the viewport is overscrolled
       * @return Returns the part per mille of the viewport that the items should be moved to
       */
      virtual FeatStd::Float Overscroll(FeatStd::Float viewportFraction) = 0;

      /**
       * @param viewportFraction - the part per mille of the fraction that the viewport is overscrolled
       * @param timeMs - the time in milliseconds from the start of the relaxation
       * @param relaxValue - out parameter; the part per mille of the viewport that the items should be moved to
       * @return Returns true while relax is not finished; false when it's finished
       */
      virtual bool Relax(FeatStd::Float viewportFraction, FeatStd::Float timeMs, FeatStd::Float& relaxValue) = 0;
};


#endif
