/* ***************************************************************************************
* FILE:          Normalizer.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Normalizer is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef Normalizer_H
#define Normalizer_H

#include <FeatStd/Platform/Types.h>
#include <Widgets/2D/List/Content/ItemSizesContainer.h>


class Normalizer
{
   public:
      virtual ~Normalizer() { };

      virtual FeatStd::Float Normalize(FeatStd::Float x, const ItemSizesContainer::SizesVector& itemSizes) const = 0;
      virtual FeatStd::Float Denormalize(FeatStd::Float x, const ItemSizesContainer::SizesVector& itemSizes) const = 0;

   private:
};


#endif
