/* ***************************************************************************************
* FILE:          ItemSwipingBehavior.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ItemSwipingBehavior is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "ItemSwipingBehavior.h"

using namespace FeatStd;
using namespace Candera;
using namespace Courier;

ItemSwipingBehavior::ItemSwipingBehavior(Swiper& swiper) :
   _swiper(swiper)
{
}


bool ItemSwipingBehavior::ScrollImpl(FeatStd::Float movementDistance, bool forward)
{
   return _swiper.ScrollList(movementDistance, forward);
}


bool ItemSwipingBehavior::SwipeImpl(FeatStd::Float movementDistance, bool forward)
{
   return _swiper.SwipeList(movementDistance, forward);
}
