/* ***************************************************************************************
* FILE:          CoverflowNormalizer.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CoverflowNormalizer is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "widget2D_std_if.h"

#include <Candera/System/Mathematics/Math.h>
#include "CoverflowNormalizer.h"


#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_LIST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/CoverflowNormalizer.cpp.trc.h"
#endif


using namespace FeatStd;
using namespace Candera;


CoverflowNormalizer::CoverflowNormalizer()
{
}


CoverflowNormalizer::~CoverflowNormalizer()
{
}


//
//Float GetAvg(const ItemSizesContainer::SizesVector& itemSizes)
//{
//   Float avg(0.0);
//
//   for (ItemSizesContainer::SizesVector::ConstIterator it(itemSizes.ConstBegin()); it != itemSizes.ConstEnd(); ++it)
//   {
//      avg += *it;
//   }
//
//   if (itemSizes.Size() > 0)
//   {
//      avg /= itemSizes.Size();
//   }
//
//   return avg;
//}


static Float GetMax(const ItemSizesContainer::SizesVector& itemSizes)
{
   Float max(0);

   for (ItemSizesContainer::SizesVector::ConstIterator it(itemSizes.ConstBegin()); it != itemSizes.ConstEnd(); ++it)
   {
      if (*it > max)
      {
         max = *it;
      }
   }

   return max;
}


static Float Func(const ItemSizesContainer::SizesVector& itemSizes)
{
   return GetMax(itemSizes);
}


Float CoverflowNormalizer::Normalize(Float x, const ItemSizesContainer::SizesVector& itemSizes) const
{
   const Float avgSize(Func(itemSizes));

   if (avgSize != 0)
   {
      x /= avgSize;
   }
   else
   {
      x = itemSizes.Size();
   }

   if (x == 0)
   {
      x = 1.0F;
   }

   return x;
}


Float CoverflowNormalizer::Denormalize(Float x, const ItemSizesContainer::SizesVector& itemSizes) const
{
   const Float avgSize(Func(itemSizes));

   if (avgSize != 0)
   {
      x *= avgSize;
   }

   return x;
}
