/* ***************************************************************************************
* FILE:          ItemSnapperHelper.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ItemSnapperHelper is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef ItemSnapperHelper_H
#define ItemSnapperHelper_H

#include <FeatStd/FeatStd.h>
#include <Widgets/2D/List/Snapping/ItemSnapper.h>

class ItemSnapperHelper
{
   public:
      FeatStd::Float GetDeltaToCenter(const ItemSnapper::SnappingInfo& snappingInfo) const;
      FeatStd::Int32 GetCenterItemIndex(const ItemSnapper::SnappingInfo& snappingInfo) const;

      /* Calculates effective node positions and sizes by removing margins of the child nodes
      and adding the margin of the itemsNode - set when pixel wise scrolling - to the position of the child nodes */
      void GetEffectiveNodePositions(const ItemSnapper::SnappingInfo& snappingInfo, bool considerChildMargins, Candera::Internal::Vector<FeatStd::Float>& effectivePositions) const;
      void GetEffectiveNodeSizes(const ItemSnapper::SnappingInfo& snappingInfo, Candera::Internal::Vector<FeatStd::Float>& effectiveSizes) const;
};


#endif
