/* ***************************************************************************************
* FILE:          ItemSnapper.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ItemSnapper is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef ItemSnapper_H
#define ItemSnapper_H


#include "Candera/System/Container/Vector.h"
#include "Candera/System/Mathematics/Rectangle.h"
#include "Widgets/2D/List/Content/Adders/OrientationOperator.h"
#include "Widgets/2D/List/Swiping/TargetPositioner.h"
#include <Candera/Engine3D/Core/Node.h>
#include <Widgets/2D/List/Content/SizeContainer.h>
#include <AppUtils/Timer.h>
#include "Widgets/2D/List/Swiping/Normalizer.h"

class ItemSnapper
{
   public:
      typedef Candera::Internal::Vector<Candera::Float> ItemsInfoType;

      struct SnappingInfo
      {
            SnappingInfo(Candera::Node2D& itemsNode, FeatStd::Float viewportSize, OrientationOperator orientationOperator, const bool forward, const bool scrolling, FeatStd::Float currentPosition, FeatStd::Float deltaPosition);

            Candera::Node2D& _itemsNode;
            const FeatStd::Float _viewportSize;
            OrientationOperator _orientationOperator;
            ItemsInfoType _nodePositions;
            ItemsInfoType _nodeSizes;
            const bool _forward;
            const bool _scrolling;
            const FeatStd::Float _currentPosition;
            const FeatStd::Float _deltaPosition;

         private:
            // private copy constructor and assignment operator, not intended to be called
            SnappingInfo(const SnappingInfo& other);
            SnappingInfo& operator =(const SnappingInfo& other);
      };

      ItemSnapper(TargetPositioner& targetPositioner);
      virtual ~ItemSnapper();

      void SetActive(bool active);
      bool IsActive() const
      {
         return _active;
      }

      void SetPagewiseSnap(bool pagewiseSnap);
      bool GetPagewiseSnap() const
      {
         return _pagewiseSnap;
      }

      void SetForward(bool forward);

      /*
       * scrolling is true if the list is scrolling and false if the list is swiping
       */
      void SetScrolling(bool scrolling);

      void SetThreshold(FeatStd::UInt32 threshold);
      void SetSnapHoldMaxTime(FeatStd::UInt32 holdMaxTime);
      void SetTouchPos(FeatStd::Float touchPos);
      void SetNormalizer(Normalizer* normalizer);

      void StartHoldTimer();
      void StopHoldTimer();

      void Snap(Candera::Node2D& itemsNode, SizeContainer& itemSizeContainer, const Candera::Vector2& viewPort, OrientationOperator orientationOperator, FeatStd::Float currentPosition, FeatStd::Float deltaPosition);

   protected:
      TargetPositioner& GetTargetPositioner();
      FeatStd::UInt32 GetThreshold() const
      {
         return _threshold;
      }
      FeatStd::UInt32 GetSnapHoldMinTime() const
      {
         return _snapHoldMaxTime;
      }
      FeatStd::UInt32 GetSnapHoldTime() const
      {
         return _snapHoldTime;
      }
      FeatStd::Float GetTouchPos() const
      {
         return _touchPos;
      }
      const Normalizer* GetNormalizer() const
      {
         return _normalizer;
      }

   private:
      bool _active;
      bool _forward;
      bool _scrolling;
      bool _pagewiseSnap;
      FeatStd::UInt32 _threshold;
      FeatStd::UInt32 _snapHoldMaxTime;
      FeatStd::UInt32 _snapHoldTime;
      FeatStd::Float _touchPos;
      Util::Timer _snapHoldTimer;

      TargetPositioner& _targetPositioner;
      Normalizer* _normalizer;

      virtual void SnapImpl(const SnappingInfo& itemsInfo) = 0;
};


#endif
