/* ***************************************************************************************
* FILE:          EdgeItemSnapper.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  EdgeItemSnapper is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef EdgeItemSnapper_H
#define EdgeItemSnapper_H

#include "ItemSnapper.h"

class EdgeItemSnapper : public ItemSnapper
{
   public:
      EdgeItemSnapper(TargetPositioner& targetPositioner);
      virtual ~EdgeItemSnapper();

   private:
      FEATSTD_TYPEDEF_BASE(ItemSnapper);
      virtual void SnapImpl(const SnappingInfo& snappingInfo) override;

      FeatStd::Float GetDeltaToEdge(const SnappingInfo& snappingInfo) const;
};


#endif
