/* ***************************************************************************************
* FILE:          AnimatedCenterItemSnapper.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AnimatedCenterItemSnapper is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef AnimatedCenterItemSnapper_H
#define AnimatedCenterItemSnapper_H

#include "ItemSnapper.h"
#include <Widgets/2D/List/Snapping/CenterItemSnapper.h>
#include <FeatStd/Platform/Types.h>

class AnimatedCenterItemSnapper : public CenterItemSnapper
{
   public:
      AnimatedCenterItemSnapper(TargetPositioner& targetPositioner);
      virtual ~AnimatedCenterItemSnapper();

   private:
      FEATSTD_TYPEDEF_BASE(CenterItemSnapper);
      virtual void SnapImpl(const SnappingInfo& snappingInfo) override;

      FeatStd::Float PerformSwipeSmallSnap(const ItemSnapper::SnappingInfo& snappingInfo) const;
      FeatStd::Float PerformSwipeBigSnap(const ItemSnapper::SnappingInfo& snappingInfo) const;
      FeatStd::Float PerformSnap(bool forward, FeatStd::Float firstItemPosition) const;
};


#endif
