/* ***************************************************************************************
* FILE:          AnimatedCenterItemSnapper.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AnimatedCenterItemSnapper is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "widget2D_std_if.h"
#include "AnimatedCenterItemSnapper.h"
#include "ItemSnapperHelper.h"

#if ((COURIER_VERSION_MAJOR > 3) || ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5)))
#include <Candera/EngineBase/Layout/Layouter.h>
#else
#include <Candera/Engine2D/Layout/Layouter.h>
#endif

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_LIST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/AnimatedCenterItemSnapper.cpp.trc.h"
#endif
using namespace Candera;

AnimatedCenterItemSnapper::AnimatedCenterItemSnapper(TargetPositioner& targetPositioner) :
   Base(targetPositioner)
{
}


AnimatedCenterItemSnapper::~AnimatedCenterItemSnapper()
{
}


void AnimatedCenterItemSnapper::SnapImpl(const SnappingInfo& snappingInfo)
{
   Float firstItemPosition(snappingInfo._currentPosition);
   ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "AnimatedCenterItemSnapper::SnapImpl animated firstItemPosition=%f, scrolling=%d, positionDelta=%f",
                       firstItemPosition, snappingInfo._scrolling, snappingInfo._deltaPosition));
   if ((!snappingInfo._scrolling) && (Math::Absolute(snappingInfo._deltaPosition) < 0.5F))
   {
      firstItemPosition = PerformSwipeSmallSnap(snappingInfo);
   }
   else
   {
      firstItemPosition = PerformSwipeBigSnap(snappingInfo);
   }

   GetTargetPositioner().SetTargetPosition(firstItemPosition, false);
}


FeatStd::Float AnimatedCenterItemSnapper::PerformSwipeSmallSnap(const ItemSnapper::SnappingInfo& snappingInfo) const
{
   const Float firstItemPosition(snappingInfo._currentPosition);
   const bool forward(snappingInfo._forward);

   return PerformSnap(forward, firstItemPosition);
}


FeatStd::Float  AnimatedCenterItemSnapper::PerformSwipeBigSnap(const ItemSnapper::SnappingInfo& snappingInfo) const
{
   Float firstItemPosition(snappingInfo._currentPosition);
   const FeatStd::Int32 calculatedCenter(snappingInfo._nodeSizes.Size() / 2);
   const FeatStd::Int32 centerItemIndex(ItemSnapperHelper().GetCenterItemIndex(snappingInfo));

   ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "AnimatedCenterItemSnapper::SnapImpl circular firstItemPosition=%f, calculatedCenter=%d, centerItemIndex=%d, positionDelta=%f",
                       firstItemPosition, calculatedCenter, centerItemIndex, snappingInfo._deltaPosition));

   const bool forward(calculatedCenter == centerItemIndex);

   return PerformSnap(forward, firstItemPosition);
}


FeatStd::Float  AnimatedCenterItemSnapper::PerformSnap(bool forward, FeatStd::Float firstItemPosition) const
{
   if (forward)
   {
      firstItemPosition = Math::Ceil(firstItemPosition);
   }
   else
   {
      firstItemPosition = Math::Floor(firstItemPosition);
   }

   return firstItemPosition;
}
