/* ***************************************************************************************
* FILE:          LockoutManager.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ListWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef LockoutManager_H
#define LockoutManager_H

#include <FeatStd/Util/ConvenienceMacros.h>
#include "Widgets/2D/List/generated/ListEnums.h"
#include "Widgets/2D/List/generated/ListMessages.h"

class LockoutManager
{
   public:
      LockoutManager();
      virtual ~LockoutManager();

      bool IsMoveAllowed(ListGeneralChangeType changeType, ListChangeMsgSourceType listSource) const;
      void ProcessLockOutMsg(const LockOutMsg& lockOutMsg);
      void AlterListChangeMsg(ListChangeMsg& lstChangeMsg) const;
      bool IsPagewiseLockout() const;
      bool IsAnyLockout() const;
      bool AcceptImmediatePositioning() const;

      void UpdateOperationDirection(ListStatusDirectionType direction);
      void UpdateOperationDirection(bool forward);

      ListStatusDirectionType GetCurrentDirection() const;
   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(LockoutManager);

      LockOutType _lockOutType;
      ListStatusDirectionType _currentDirection;
};


#endif
