/* ***************************************************************************************
* FILE:          LockoutManager.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  LockoutManager is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "LockoutManager.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_LIST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/LockoutManager.cpp.trc.h"
#endif

using namespace Candera;
using namespace Courier;

LockoutManager::LockoutManager() :
   _lockOutType(LockOutNone),
   _currentDirection(ListStatusDirectionUnavailable)
{
}


LockoutManager::~LockoutManager()
{
}


bool LockoutManager::IsMoveAllowed(ListGeneralChangeType changeType, ListChangeMsgSourceType listSource) const
{
   bool allowed(false);
   allowed = allowed || (_lockOutType == LockOutNone);
   allowed = allowed || ((_lockOutType == LockOutDirPrev) && (_currentDirection == ListStatusDirectionNext));
   allowed = allowed || ((_lockOutType == LockOutDirNext) && (_currentDirection == ListStatusDirectionPrev));
   allowed = allowed || ((_lockOutType == LockOutPageWise) && (changeType == ListSetChange) && (listSource == ListChangeMsgSourceUnknown));
   allowed = allowed || ((_lockOutType == LockOutPageWise) && (changeType == ListPageChange));
   allowed = allowed || ((_lockOutType == LockOutPageWise) && (changeType == ListTouchChange));
   allowed = allowed || ((_lockOutType == LockOutFixMovement) && (changeType == ListTouchChange));
   allowed = allowed || ((_lockOutType == LockOutPageWisePrev) && (_currentDirection == ListStatusDirectionPrev) && (changeType == ListSetChange) && (listSource == ListChangeMsgSourceUnknown));
   allowed = allowed || ((_lockOutType == LockOutPageWisePrev) && (_currentDirection == ListStatusDirectionPrev) && (changeType == ListPageChange));
   allowed = allowed || ((_lockOutType == LockOutPageWisePrev) && (_currentDirection == ListStatusDirectionPrev) && (changeType == ListTouchChange));
   allowed = allowed || ((_lockOutType == LockOutPageWiseNext) && (_currentDirection == ListStatusDirectionNext) && (changeType == ListSetChange) && (listSource == ListChangeMsgSourceUnknown));
   allowed = allowed || ((_lockOutType == LockOutPageWiseNext) && (_currentDirection == ListStatusDirectionNext) && (changeType == ListPageChange));
   allowed = allowed || ((_lockOutType == LockOutPageWiseNext) && (_currentDirection == ListStatusDirectionNext) && (changeType == ListTouchChange));

   return allowed;
}


void LockoutManager::ProcessLockOutMsg(const LockOutMsg& lockOutMsg)
{
   _lockOutType = lockOutMsg.GetLockOut();
}


void LockoutManager::AlterListChangeMsg(ListChangeMsg& lstChangeMsg) const
{
   switch (_lockOutType)
   {
      case  LockOutPageWise:
      case  LockOutPageWisePrev:
      case  LockOutPageWiseNext:
      {
         //set the new change type in case of page lockout
         switch (lstChangeMsg.GetListChangeType())
         {
            case ListChangeUp:
               lstChangeMsg.SetListChangeType(ListChangePageUp);
               break;
            case ListChangeDown:
               lstChangeMsg.SetListChangeType(ListChangePageDown);
               break;
            default:
               // do nothing
               break;
         }
      }
      break;

      case LockOutNone:
      case LockOutDirPrev:
      case LockOutDirNext:
      case LockOutComplete:
      default:
         //no action
         break;
   }
}


bool LockoutManager::IsPagewiseLockout() const
{
   return ((LockOutPageWise == _lockOutType) ||
           (LockOutPageWisePrev == _lockOutType) ||
           (LockOutPageWiseNext == _lockOutType) ||
           (LockOutFixMovement == _lockOutType));
}


bool LockoutManager::IsAnyLockout() const
{
   return _lockOutType != LockOutNone;
}


bool LockoutManager::AcceptImmediatePositioning() const
{
   return IsPagewiseLockout();
}


void LockoutManager::UpdateOperationDirection(ListStatusDirectionType direction)
{
   if (direction != _currentDirection)
   {
      _currentDirection = direction;
   }
}


void LockoutManager::UpdateOperationDirection(bool forward)
{
   UpdateOperationDirection(forward ? ListStatusDirectionNext : ListStatusDirectionPrev);
}


ListStatusDirectionType LockoutManager::GetCurrentDirection() const
{
   return _currentDirection;
}
