/* ***************************************************************************************
* FILE:          ListWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ListWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef List_Widget_2D_H
#define List_Widget_2D_H

#include <Widgets/2D/List/generated/ListWidget2DBase.h>
#include <Widgets/2D/List/Content/ListContentUpdater.h>
#include <Widgets/2D/ControlTemplate/ControlTemplateCloningStrategy.h>
#include <Widgets/2D/Focus/FocusGroupWidget2D.h>
#include <Widgets/2D/List/Data/ListDataWrapper.h>
#include <Candera/EngineBase/Animation/AnimationPlayerListener.h>
#include <Widgets/2D/List/Content/TimeDispatcher.h>
#include <Widgets/2D/List/Data/ListDataProviderCache.h>
#include <Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h>
#include <Widgets/2D/List/Layouting/LayoutingListener.h>
#include <Widgets/2D/List/Swiping/SwipingListener.h>
#include <Widgets/2D/List/Content/FlexPixelWiseAnimationManagerListener.h>
#include <Widgets/2D/List/Animations/ExpandTriggerManager.h>
#include <Widgets/2D/List/Content/SwipingListContentUpdater.h>
#include <Widgets/2D/List/Content/Adders/OrientationOperator.h>
#include <CanderaAssetLoader/AssetLoaderBase/AnimationPlayerDataType.h>
#include <CanderaAssetLoader/AssetLoader2D/AssetLoader2DDataTypes.h>
#include <Widgets/2D/List/Lockout/LockoutManager.h>
#include <Widgets/2D/WidgetGestureConfig.h>
#include <Widgets/2D/List/Animations/CustomAnimationsContainer.h>
#include <Widgets/2D/List/Swiping/SwipingStrategy.h>
#include <Widgets/2D/List/Snapping/ItemSnapper.h>
#include <Widgets/2D/List/Swiping/Normalizer.h>
#include <Widgets/2D/List/Internal/DefaultOwnerInfoRetriever.h>
#include <Widgets/2D/List/Content/TemplateRetriever.h>
#include <Widgets/2D/List/Animations/ExpandAdjuster.h>
#include <Widgets/2D/List/Content/DefaultSwipingListContentUpdaterListener.h>
#include <Widgets/2D/List/Swiping/SwipePositionObserver.h>
#include <Widgets/2D/List/Animations/ItemSpeedAnimationManager.h>

#ifndef COURIER_VERSION_MAJOR
#error COURIER_VERSION_MAJOR not defined
#endif

#define FLEX_LIST_WIDGET_CHECK_AND_PROPERTY_SET(name) \
   void FEATSTD_CONCAT2(CheckAndSet,name)(const FEATSTD_CONCAT2(name,Type)& value) \
   { \
      if (FEATSTD_CONCAT2(Get,name)() != value) \
      { \
         FEATSTD_CONCAT2(Set,name)(value); \
      } \
   }

class ListWidget2D : public ListWidget2DBase,
   public FlexScrollable,
   public FocusGroupBase,
   public ControlTemplateInstanceOwner,
   private LayoutingListener,
   private SwipingListener,
   private Candera::Animation::AnimationPlayerListener,
   protected TimeDispatcher,
   private FlexPixelWiseAnimationManagerListener
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      typedef bool(*FocusStrategy)(ListWidget2D& listWidget, const ListChangeMsg& msg, bool force);
      typedef void(*MsgDisposer)(const Courier::Message* originalMsg);
      typedef const Courier::Message* (*MsgTranslatorStrategy)(const Courier::Message& originalMsg, MsgDisposer& disposer);

      static void SetMsgTranslatorStrategy(MsgTranslatorStrategy msgTranslatorStrategy);
      static void SetFocusStrategy(FocusStrategy focusStrategy);
      static void SetDefaultFocusControllers(Focus::FControllerSetId setId);
      static void SetListDataProviderCache(ListDataProviderCache* listDataProviderCache);

      CGI_WIDGET_RTTI_DECLARATION(ListWidget2D, ListWidget2DBase);

      ListWidget2D();
      virtual ~ListWidget2D();

      virtual bool IsDynamicGridPropertyVisible() const;
      virtual bool IsFixedPageScrollingOffsetPropertiesVisible() const;
      virtual bool AreFixedPageScrollingPropertiesVisible() const;

      virtual void OnParentViewLoad(bool activate);

      virtual void Finalize();

      virtual bool OnTouch(const Candera::Camera2D& camera, const Candera::Vector2& point);
      virtual bool OnMessage(const Courier::Message& msg);

      virtual void InitWidget();
      virtual void Update();

      virtual void OnParentViewRenderingEnabled(bool enable);

      virtual Candera::UInt32 GetEffectiveTouchPriority() const;

      /* FlexScrollable interface */
      virtual void RequestImmediatePositioning(bool active);
      virtual bool IsScrollBarVisible();
      virtual Candera::UInt32 GetPosition(); ///< returns startIndex. Virtual function defined in FlexScrollable.
      virtual FeatStd::UInt32 GetFirstFullyVisiblePosition(); // returns the index of the first fully visible item
      virtual Candera::UInt32 GetVisibleSize();
      virtual Candera::UInt32 GetCompleteSize();
      virtual Candera::Widget2D* GetWidget();
      virtual Candera::UInt32 GetMaxPosition();
      virtual bool IsCircular();

      FeatStd::Int32 GetEffectiveNumberOfItems() const;

      FEATSTD_LINT_NEXT_EXPRESSION(1511, "Overwrite of base class (FlexListWidget2DBase) method not intended. ")
      virtual const ::Candera::ListScrollingOrientation& GetScrollingOrientation() const;
      virtual void SetListener(FlexScrollableListener* listener);

      /* FlexScrollable interface end*/

      virtual bool IsNumberOfItemsVisible() const;
      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

      //Inherited from LimitListener.
      virtual void OnLimitExceededUp();
      virtual void OnLimitExceededDown();
      virtual void OnLimitReachedUp();
      virtual void OnLimitReachedDown();

      virtual void OnPastEnd(Candera::Animation::AnimationPlayerBase* animationPlayer, Candera::Int32 completedIterationsCount);
      virtual void OnStopAnimation(Candera::Animation::AnimationPlayerBase* animationPlayer);

      void CheckListLimits();
      bool IsListMovementFinished() const;

      FLEX_LIST_WIDGET_CHECK_AND_PROPERTY_SET(FocusedIndex)
      FLEX_LIST_WIDGET_CHECK_AND_PROPERTY_SET(StartIndex)
      FLEX_LIST_WIDGET_CHECK_AND_PROPERTY_SET(NumberOfItems)

      bool HasItems() const
      {
         return (!_items.PointsToNull()) || (_listData.IsDataAvailable());
      }

      const ListDataWrapper& GetDataWrapper() const
      {
         return _listData;
      }

//     const tSharedPtrDataProvider& GetDataProvider() const
//     {
//         return _listData.GetDataProvider();
//     }

      Candera::Node2D* GetListItemsNode() const
      {
         return (0 != GetItemsNode()) ? GetItemsNode() : GetNode();
      }

      const PagesInfo& GetPagesInfo() const;

      void ForceMovement();

      TemplateScrollAnimationType GetScrollAnimations() const
      {
         return _animationArray;
      }

      CdaWidget2DDef(ListWidget2D, ListWidget2DBase)

      CdaDescription("Provides support for creating lists of elements. See the list widget documentation.")
      CdaReadableName("ListWidget2D")
      CdaCategory("List")

      CdaProperties() //Start of properties

      // Focus handling
      CdaProperty_FocusGroupConfigured()
      CdaProperty_FocusGroupWrapAround()
      CdaProperty_FocusGroupPreserveFocus()
      CdaProperty_FocusGroupDefaultFocusOrder()
      CdaProperty_FocusGroupLayer()

      // Scroll Animations - added here instead of base class as FieldProperties are not supported by the Generator
      CdaFieldProperty(TemplateScrollAnimations, TemplateScrollAnimationType, _animationArray)
      CdaDescription("Array of template animations for list scrolling.")
      CdaCategory("Template Animations")
      CdaPropertyEnd()

      CdaFieldProperty(CustomListAnimations, CustomListAnimationType, _customAnimations)
      CdaDescription("Array of animations for all visible list elements.")
      CdaCategory("Custom Animations")
      CdaPropertyEnd()

      CdaPropertiesEnd() // End of properties

      CdaWidgetDefEnd()

   protected:
      virtual bool composerPropVisibleFilterDrag() const override
      {
         return true;
      }

      virtual bool composerPropVisibleFilterDragDirection() const override
      {
         return false;
      }

      virtual bool composerPropVisibleFilterSwipe() const override
      {
         return true;
      }

      virtual bool composerPropVisibleFilterSwipeDirection() const override
      {
         return false;
      }

      virtual void OnCloneUpdateBegin(const ControlTemplateInstancePtr& controlTemplateInstance)
      {
         _currentCloningControlTemplateInstance = controlTemplateInstance;
         if (!_currentCloningControlTemplateInstance.PointsToNull())
         {
            _currentCloningControlTemplateInstance->SetScrollAnimationOffset(GetAnimationOffset());
            _currentCloningControlTemplateInstance->SetScrollAnimationInput(GetScrollAnimationInput());
         }
      }

      virtual void OnCloneUpdateEnd(const ControlTemplateInstancePtr& /*controlTemplateInstance*/)
      {
         _currentCloningControlTemplateInstance = ControlTemplateInstancePtr();
      }

      virtual void OnChanged(Courier::UInt32 propertyId);

      virtual void OnPreMeasure(Candera::Node2D& node, const Candera::Vector2& clientArea);
      virtual void OnPostArrange(Candera::Node2D& node, const Candera::Rectangle& clientArea);

      tSharedPtrListDataItem GetDataItem(Candera::Int32 index);
      virtual bool OnTouchMessage(const Courier::TouchMsg& msg);
      virtual void RegisterToFocusManagerImpl(Focus::FManager& focusManager, Focus::FSession& session, Focus::FWidgetConfig& handle);

      bool _itemsInvalid;
      SizeContainer _sizesContainer;
      SwipingListContentUpdater _listContentUpdater;

      void UpdateContent();

      void NotifyOnPositionReached();
      void NotifyOnContentUpdated();

      virtual void OnAnimationTimeDispatcherChanged();

      virtual WidgetGestureConfig getDefaultGestureConfig() const override;
      virtual WidgetGestureConfig getGestureConfig() const override;

      virtual bool OnDragGesture(const hmibase::input::gesture::GestureEvent& gestureData);
      virtual bool OnSwipeGesture(const hmibase::input::gesture::GestureEvent& gestureData);

      void UpdateInvalidations(bool invalidate, bool invalidateLayout);

   private:

      // private copy constructor and assignment operator, not intended to be called
      ListWidget2D(const ListWidget2D& other);
      ListWidget2D& operator =(const ListWidget2D& other);

      static FocusStrategy& FlexListWidget2DGetFocusStrategy();
      static ListDataProviderCache* sListDataProviderCache;

      FEATSTD_LINT_NEXT_EXPRESSION(1768, "Private inheritance used, so method should have no reason to be public.")
      virtual void OnGestureBegin(const Candera::Vector2& position) override;

      FEATSTD_LINT_NEXT_EXPRESSION(1768, "Private inheritance used, so method should have no reason to be public.")
      virtual bool OnSwipeStart(const Candera::Float estimatedDistance);

      FEATSTD_LINT_NEXT_EXPRESSION(1768, "Private inheritance used, so method should have no reason to be public.")
      virtual bool OnSwipe(const Candera::Float movementDistance, const bool forward);

      FEATSTD_LINT_NEXT_EXPRESSION(1768, "Private inheritance used, so method should have no reason to be public.")
      virtual bool OnSwipeEnd();

      FEATSTD_LINT_NEXT_EXPRESSION(1768, "Private inheritance used, so method should have no reason to be public.")
      virtual bool OnScrollStart(const Candera::Vector2& pos);

      FEATSTD_LINT_NEXT_EXPRESSION(1768, "Private inheritance used, so method should have no reason to be public.")
      virtual bool OnScroll(const Candera::Float movementDistance, const bool forward);

      FEATSTD_LINT_NEXT_EXPRESSION(1768, "Private inheritance used, so method should have no reason to be public.")
      virtual bool OnScrollEnd(const Candera::Vector2& pos);

      FEATSTD_LINT_NEXT_EXPRESSION(1768, "Private inheritance used, so method should have no reason to be public.")
      virtual void OnStateChanged(const SwipingState::Enum state);

      void UpdateFocus(Candera::Float movementDistance);

      void UpdateStartIndex(ListWidget2DBase::StartIndexType startIndex);

      class FocusedLayouter : public Candera::Layouter
      {
         public:
            FocusedLayouter() : _listWidget(0) { }

            void SetListWidget(ListWidget2D* listWidget)
            {
               _listWidget = listWidget;
            }

            virtual void Dispose() { };

         protected:
            Candera::Vector2 OnMeasure(Candera::Node2D& node, const Candera::Vector2& clientArea);
            void OnArrange(Candera::Node2D& node, const Candera::Rectangle& clientArea);
#if ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR > 4))
            virtual Candera::Vector2 OnMeasure(const Candera::AbstractNodePointer& node, const Candera::Vector2& clientArea) override
            {
               return OnMeasure(*(node.ToNode2D()), clientArea);
            }
            virtual void OnArrange(const Candera::AbstractNodePointer& node, const Candera::Rectangle& clientArea) override
            {
               OnArrange(*(node.ToNode2D()), clientArea);
            }
#endif
#if defined SESA_ARABIC_LAYOUT_FIX
            virtual void OnClipping(Candera::Node2D& node, const Candera::Rectangle& clientArea);
#endif

            virtual Candera::Layouter* Clone() const
            {
               return 0; // instance is part of the FlexListWidget. therefore, it is not allowed to clone itself. the instance has to be set by the flex list itself.
            }

            ListWidget2D* _listWidget;
            Candera::Vector2 _measuredSize;
      };

      friend class FocusedLayouter;
      friend class DropDownListWidget2D;

      enum LimitAnimationPlayerId
      {
         ExceedUp = 0,
         ExceedDown = 1,
         ReachUp = 2,
         ReachDown = 3,
         LimitAnimationPlayerCount = 4
      };

      struct LimitAnimationPlayer
      {
         public:

            LimitAnimationPlayer() :
               player(0),
               type(Candera::NoAnimation),
               invalid(false)
            {
            }

            Candera::MemoryManagement::SharedPointer<Candera::Animation::AnimationPlayer> player;
            Candera::LimitAnimationType type;
            bool invalid;
      };

      /**
       * Determine whether or not new data needs to be requested from the data provider. Sets the flags _dataProviderInvalid and _delayItemValidation as needed.
       */
      void ValidateDataProvider();

      /**
       *  Requests new data from the data provider starting at a specific index.
       */
      void PostListDataRequestMsg(Candera::UInt32 startIndex);

      Candera::Node2D* GetFocusedItem() const
      {
         return _listContentUpdater.GetFocusedItem();
      }

      void PlayAnimation(LimitAnimationPlayerId id, Candera::MemoryManagement::SharedPointer<Candera::Animation::AnimationPlayer> player);
      bool IsAnimationRunning(Candera::MemoryManagement::SharedPointer<Candera::Animation::AnimationPlayer> player) const;
      void UpdatePlayer(LimitAnimationPlayerId id);
      Candera::MemoryManagement::SharedPointer<Candera::Animation::AnimationPlayer> GetCustomAnimationPlayer(LimitAnimationPlayerId id);
      Candera::UInt32 GetAnimationTime(LimitAnimationPlayerId id);
      void InvalidateLimiterAnimation(LimitAnimationPlayerId id)
      {
         _limiterAnimationsInvalid = true;
         _currentLimitAnimationPlayer[id].invalid = true;
      }
      void ValidateLimiterAnimations();
      bool AreLimiterAnimationsInvalid() const
      {
         return _limiterAnimationsInvalid;
      }
      bool IsLimiterAnimationInvalid(LimitAnimationPlayerId id) const
      {
         return _currentLimitAnimationPlayer[id].invalid;
      }

      void ResetStatemachineToIdle();

      void SetListMovement(ListMovementStatusType listMovement);

      FEATSTD_LINT_NEXT_EXPRESSION(1768, "Private inheritance used, so method should have no reason to be public.")
      virtual FeatStd::UInt32 GetTimeMs();

      virtual void OnAnimationFinished();

      bool AreAllElementsVisible();

      void OnDataChanged(StartIndexType requestedStartIndex);

      void UpdateInit();
      void UpdateTemplateWidgets();

      void UpdateScrollingSpeed();
      void SetStartIndexInternally(StartIndexType startIndex);

      void HideNode(Candera::Node2D* node) const;

      void RetrieveDataFromCache();
      Courier::Message* GetCachedDataMessage();

      void OnListChangeMsg(const ListChangeMsg* lstChangeMsg, bool& msgConsumed, bool& shouldForwardMsg);
      void OnListAnimatedChangeReqMsg(const ListAnimatedChangeReqMsg& lstChangeMsg, bool& msgConsumed, bool& shouldForwardMsg);

      void ProcessListChangeMsg(const ListChangeMsg& lstChangeMsg, bool& msgConsumed, bool& shouldForwardMsg);

      void OnListDateProviderResMsg(const ListDateProviderResMsg* listDataResultMsg);
      void OnListDateProviderUpdMsg(const ListDataProviderUpdMsg* listDataUpdateMsg);
      void OnParentViewRenderingEnabledEvent(const Courier::ParentViewRenderingEnabledEvent* parentViewRenderingEnableEvent, bool& msgConsumed, bool& shouldForwardMsg);
      void OnParentViewActivateEvent(const Courier::ParentViewActivateEvent* parentViewActivateEvent, bool& msgConsumed, bool& shouldForwardMsg);
      void OnLockOutMsg(const LockOutMsg* lockOutMsg);

      void OnListItemExpandReqMsg(const ListItemExpandReqMsg* expandReqMsg);

      void TryPostListChangedMsg();
      void TryPostListStatusUpdMsg();
      void PostListContentUpdMsg();

      /**
       *  Determine the effective visibility of the list and notify if it changed.
       */
      void UpdateEffectiveVisibiliy(bool forceInvisible = false);

      void UpdateListState(ListChangeMsgSourceType source);
      bool UpdateExpandAnimations(ExpandAdjuster::AdjustData& expandData);
      bool UpdateCustomAnimations();

      void UpdateNormalizer();

      virtual bool IsEffectiveVisible() const;

      void OnListStateChanged(ListStatusType state);
      void UpdateToIdle();

      bool ImmediatePositioningSet() const;
      void UpdateSnapper();

      bool HasScrollAnimations() const;
      void HideTemplates();
      bool IsTouchCameraValid();

      bool IsBouncing() const;
      void ValidateItemsGroup() const;

      void UpdateClippingRectangle(Candera::Node2D* itemsNode);
      void UpdateNodeTouchableRectangle();
      void InternalInvalidate();

      virtual void PerformUpdate(bool& invalidate, bool& invalidateLayout);

      void UpdateCachedCloningBehavior();

      void OnNodeChanged();

      bool ShouldProcessListChangeMsg();
      void UpdateViewportSize();

      bool _delayItemValidation; ///< Delay requesting item validation.
      bool _requestPending;
      bool _dataProviderInvalid; ///< New data needs to be requested from the data provider.
      bool _activ;
      bool _initialized;
      bool _dataReceived;
      bool _expandAnimationRunning;
      bool _customAnimationsRunning;

      ListDataWrapper _listData; ///< wrapper for ListDataProvider.
      FocusedLayouter _focusedLayouter;
      tSharedPtrListDataItem _items;
      DefaultOwnerInfoRetriever _ownerInfoRetriever;
      ControlTemplateInstanceContainer _itemsInstanceContainer;
      ListContentUpdater::ScrollingSpeed _scrollingSpeed;
      static Focus::FControllerSetId _defaultFocusControllers;

      Candera::Rectangle _clippingRectangle;
      Candera::Rectangle _touchableRectangle;

      bool _limiterAnimationsInvalid;
      LimitAnimationPlayer _currentLimitAnimationPlayer[LimitAnimationPlayerCount];
      LimitAnimationPlayerId _currentLimitAnimationPlayerId;
      FeatStd::UInt32 _frameTime;
      ControlTemplateInstancePtr _currentCloningControlTemplateInstance;
      FlexScrollableListener* _listener;
      bool _immediatePositioningRequested;
      bool _startIndexInternallySet;
      OrientationOperator _orientationOperator;
      OrientationOperator _orthogonalOrientationOperator;
      FeatStd::Int32 _firstElementIndex;
      TemplateScrollAnimationType _animationArray;
      CustomListAnimationType _customAnimations;
      bool _firstSetAfterRenderingEnabled;
      ListMovementStatusType _movementStatus;
      ListMovementStatusType _oldMovementStatus;
      bool _forceMovement;
      bool _statusChanged;
      ListGeneralChangeType _changeType;
      ListStatusType _currentListStatus;
      ListStatusVisibilityType _currentEffectiveVisible;
      ListChangeMsgSourceType _currentListChangeMsgSourceType;
      ExpandTriggerManager _expandTriggerManager;
      LockoutManager _lockoutManager;
      CustomAnimationsContainer _animationContainer;
      bool _receivedListCustomAnimationReqMsg;
      SwipingStrategy _swipingStrategy;
      bool _immediatePositioning;
      ListChangeType _listChangeType;
      ItemSnapper* _snapper;
      const Candera::Camera2D* _touchCamera;
      bool _restoreContentUpdaterState;
      Normalizer* _normalizer;
      ClonedItemCachingBehavior::SharedPointer _cachedCloningBehavior;
      TemplateRetriever _templateRetriever;
      ContentProvider _contentProvider;
      bool _updateCalled;
      ExpandAdjuster _expandAdjuster;
      DefaultSwipingListContentUpdaterListener _listUpdaterListener;
      SwipePositionObserver _swipePositionObserver;
      ItemSpeedAnimationManager _itemSpeedAnimationManager;
};


#endif
