/* ***************************************************************************************
* FILE:          ListController2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ListController2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <View/CGI/Widget/WidgetController.h>


namespace hmibase {
namespace widget {
namespace list {

/****************************************************************************/
class ListController2DData : public hmibase::widget::WidgetControllerData
{
      FEATSTD_TYPEDEF_BASE(hmibase::widget::WidgetControllerData);

   public:
      CANDERA_RTTI_DECLARATION(ListController2DData);
};


/****************************************************************************/
class ListController2D : public hmibase::widget::WidgetController
{
      FEATSTD_TYPEDEF_BASE(hmibase::widget::WidgetController);

   public:
      CANDERA_RTTI_DECLARATION(ListController2D);

      WIDGET_CONTROLLER_ON_GESTURE()
      virtual bool OnTapGesture(DelegateWidget&, const hmibase::input::gesture::GestureEvent&)
      {
         return false;
      }
      virtual bool OnDragGesture(DelegateWidget&, const hmibase::input::gesture::GestureEvent&)
      {
         return false;
      }
      virtual bool OnSwipeGesture(DelegateWidget&, const hmibase::input::gesture::GestureEvent&)
      {
         return false;
      }
      virtual bool OnPinchSpreadGesture(DelegateWidget&, const hmibase::input::gesture::GestureEvent&)
      {
         return false;
      }
      virtual bool OnRotateGesture(DelegateWidget&, const hmibase::input::gesture::GestureEvent&)
      {
         return false;
      }
};


/****************************************************************************/
class DefaultListController2DData : public ListController2DData
{
      FEATSTD_TYPEDEF_BASE(ListController2DData);

   public:
      CANDERA_RTTI_DECLARATION(DefaultListController2DData);
};


/****************************************************************************/
class DefaultListController2D : public ListController2D
{
      FEATSTD_TYPEDEF_BASE(ListController2D);

   public:
      CANDERA_RTTI_DECLARATION(DefaultListController2D);

      virtual hmibase::widget::WidgetControllerData* CreateData(DelegateWidget&) override
      {
         return CANDERA_NEW(DefaultListController2DData);
      }
};


}
}


}
