/* ***************************************************************************************
* FILE:          LayoutingListener.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  LayoutingListener is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(LayoutingListener_H)
#define LayoutingListener_H

#include <Candera/Engine2D/Core/Node2D.h>

/**
 * The LayoutingListener can be used to react on layout events (use a FlexHookLayouter to inject external callbacks).
 */
class LayoutingListener
{
   protected:
      virtual ~LayoutingListener() { }

      friend class FlexHookLayouter;
      /**
       * The OnPreMeasure is called before the OnMeasure of the layouter is called.
       */
      virtual void OnPreMeasure(Candera::Node2D& node, const Candera::Vector2& clientArea) = 0;

      /**
       * The OnPostArrange is called after the OnArrange of the layouter is called.
       */
      virtual void OnPostArrange(Candera::Node2D& node, const Candera::Rectangle& clientArea) = 0;
};


#endif
