/* ***************************************************************************************
* FILE:          FlexListLayouter.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FlexListLayouter is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef Flex_List_Layouter_H
#define Flex_List_Layouter_H

#include "FlexHookLayouter.h"

class FlexListLayouter : public FlexHookLayouter
{
      FEATSTD_LINT_CURRENT_SCOPE(1712, "No default constructor needed.")

   public:
      FlexListLayouter(Candera::Layouter* originalLayouter);
      virtual ~FlexListLayouter();

      Candera::Vector2 GetMeasuredSize() const
      {
         return _measuredSize;
      }

   protected:
      virtual Candera::Vector2 OnMeasure(Candera::Node2D& node, const Candera::Vector2& clientArea);

#if ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5))
      virtual Candera::Vector2 OnMeasure(const Candera::AbstractNodePointer& node, const Candera::Vector2& clientArea)
      {
         return OnMeasure(*(node.ToNode2D()), clientArea);
      }
#endif

   private:
      Candera::Vector2 _measuredSize;
};


#endif
