/* ***************************************************************************************
* FILE:          FlexListLayouter.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FlexListLayouter is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"


#include "FlexListLayouter.h"

#if !defined(CANDERA_LAYOUT_CLIPPING_ENABLED)
#error "Flexlist modul needs switch CANDERA_LAYOUT_CLIPPING_ENABLED"
#endif

using namespace Candera;
using namespace Courier;

FlexListLayouter::FlexListLayouter(Candera::Layouter* originalLayouter) :
   FlexHookLayouter(originalLayouter),
   _measuredSize(0.0F, 0.0F)
{
}


FlexListLayouter::~FlexListLayouter()
{
}


Candera::Vector2 FlexListLayouter::OnMeasure(Candera::Node2D& node, const Candera::Vector2& clientArea)
{
   _measuredSize = clientArea;
   return FlexHookLayouter::OnMeasure(node, clientArea);
}
