/* ***************************************************************************************
* FILE:          FlexHookLayouter.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FlexHookLayouter is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(FlexHookLayouter_H)
#define FlexHookLayouter_H

#include <Courier/Version.h>
#include "Widgets/2D/List/Layouting/LayoutingListener.h"

#if ((COURIER_VERSION_MAJOR > 3) || ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5)))
#include <Candera/EngineBase/Layout/Layouter.h>
#else
#include <Candera/Engine2D/Layout/Layouter.h>
#endif

#include <Courier/Util/Vector.h>

/**
 * The FlexHookLayouter can be used to inject external callback (see LayoutingListener).
 */
class FlexHookLayouter : public Candera::Layouter
{
      FEATSTD_LINT_CURRENT_SCOPE(1712, "No default constructor needed.")

   public:
      FlexHookLayouter(Candera::Layouter* originalLayouter);
      virtual ~FlexHookLayouter();

      void RegisterListener(LayoutingListener* listener);

      Candera::Layouter* GetOriginalLayouter() const;

      virtual void Dispose();

      static bool& ShouldNotifyListeners();
   protected:
      Candera::Vector2 OnMeasure(Candera::Node2D& node, const Candera::Vector2& clientArea);
      void OnArrange(Candera::Node2D& node, const Candera::Rectangle& clientArea);
#if ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5))
      virtual Candera::Vector2 OnMeasure(const Candera::AbstractNodePointer& node, const Candera::Vector2& clientArea) override
      {
         return OnMeasure(*(node.ToNode2D()), clientArea);
      }

      virtual void OnArrange(const Candera::AbstractNodePointer& node, const Candera::Rectangle& clientArea) override
      {
         OnArrange(*(node.ToNode2D()), clientArea);
      }

      virtual void OnClipping(const Candera::AbstractNodePointer& node, const Candera::Rectangle& clientArea) override
      {
         OnClipping(*(node.ToNode2D()), clientArea);
      }

#endif
      virtual void OnClipping(Candera::Node2D& node, const Candera::Rectangle& clientArea);

//_TODO("CGI3 Layouter behaviour : Clone <> CloneSelf has to be checked in all classes")
      virtual Candera::Layouter* Clone() const;

   private:
      Candera::Layouter* _originalLayouter;
      Courier::Vector<LayoutingListener*> _listeners;
      Candera::Vector2 _measuredSize;
};


#endif
