/* ***************************************************************************************
* FILE:          FlexHookLayouter.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FlexHookLayouter is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if ((COURIER_VERSION_MAJOR > 3) || ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5)))
#include <Candera/EngineBase/Layout/DefaultLayouter.h>
#else
#include <Candera/Engine2D/Layout/DefaultLayouter.h>
#endif


#include "FlexHookLayouter.h"

#if defined SESA_ARABIC_LAYOUT_FIX
#if ((COURIER_VERSION_MAJOR > 3) || ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5)))
#include "Candera/EngineBase/Layout/ArabicLayouterPatch.h"
#else
#include "Candera/Engine2D/Layout/ArabicLayouterPatch.h"
#endif
#endif


using namespace Candera;


class BaseLayouter : public Candera::Layouter
{
   public:
#if ((COURIER_VERSION_MAJOR > 3) || ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5)))
      FEATSTD_LINT_NEXT_EXPRESSION(1768, "Method made public to be accessible to wrappers.")
      virtual Candera::Vector2 OnMeasure(const Candera::AbstractNodePointer& /*node*/, const Candera::Vector2& /*clientArea*/) override
      {
         return Candera::Vector2();
      }

      FEATSTD_LINT_NEXT_EXPRESSION(1768, "Method made public to be accessible to wrappers.");
      virtual void OnArrange(const Candera::AbstractNodePointer& /*node*/, const Candera::Rectangle& /*clientArea*/)
      {
      }
#else
      FEATSTD_LINT_NEXT_EXPRESSION(1768, "Method made public to be accessible to wrappers.")
      virtual Candera::Vector2 OnMeasure(Candera::Node2D& /*node*/, const Candera::Vector2& /*clientArea*/)
      {
         return Candera::Vector2();
      }

      FEATSTD_LINT_NEXT_EXPRESSION(1768, "Method made public to be accessible to wrappers.");
      virtual void OnArrange(Candera::Node2D& /*node*/, const Candera::Rectangle& /*clientArea*/)
      {
      }
#endif
      _TODO("CGI3 Layouter behaviour : Clone <> CloneSelf has to be checked in all classes")
      virtual Candera::Layouter* Clone() const

      {
         return 0;
      }
};


FlexHookLayouter::FlexHookLayouter(Candera::Layouter* originalLayouter) :
   _originalLayouter(originalLayouter)
{
   if (DefaultLayouter::GetInstance() == _originalLayouter)
   {
      _originalLayouter = 0;
   }
}


FlexHookLayouter::~FlexHookLayouter()
{
   _originalLayouter = 0; // fr83hi
}


void FlexHookLayouter::RegisterListener(LayoutingListener* listener)
{
   static_cast<void>(_listeners.Add(listener));
}


Candera::Layouter* FlexHookLayouter::GetOriginalLayouter() const
{
   return _originalLayouter;
}


void FlexHookLayouter::Dispose()
{
   if (0 != _originalLayouter)
   {
      _originalLayouter->Dispose();
   }
   Candera::Layouter::Dispose();
}


bool& FlexHookLayouter::ShouldNotifyListeners()
{
   FEATSTD_UNSYNCED_STATIC_OBJECT(bool, s_FlexHookLayouterShouldNotifyListeners, true);
   return s_FlexHookLayouterShouldNotifyListeners;
}


Candera::Vector2 FlexHookLayouter::OnMeasure(Candera::Node2D& node, const Candera::Vector2& clientArea)
{
   const Margin& margin(Layouter::GetMargin(node));
   const Int16 horizonalMargin = margin.GetLeft() + margin.GetRight();
   const Int16 verticalMargin = margin.GetTop() + margin.GetBottom();

   Vector2 nodeSize(Layouter::GetSize(node));
   const Vector2 restrictedClientArea((nodeSize.GetX() < 0.0F) ? (clientArea.GetX() + horizonalMargin) : clientArea.GetX(),
                                      (nodeSize.GetY() < 0.0F) ? (clientArea.GetY() + verticalMargin) : clientArea.GetY());

   if (FlexHookLayouter::ShouldNotifyListeners())
   {
      for (Int i = 0; i < (Int) _listeners.Size(); i++)
      {
         if (0 != _listeners[i])
         {
            _listeners[i]->OnPreMeasure(node, restrictedClientArea);
         }
      }
   }
   FEATSTD_LINT_NEXT_EXPRESSION(740, "Intended downcast.");
   BaseLayouter* baseLayouter = static_cast<BaseLayouter*>((0 != _originalLayouter) ? _originalLayouter : DefaultLayouter::GetInstance());
   if (0 != baseLayouter)
   {
      const Vector2 fullClientArea((nodeSize.GetX() >= 0.0F) ? (nodeSize.GetX() - horizonalMargin) : clientArea.GetX(),
                                   (nodeSize.GetY() >= 0.0F) ? (nodeSize.GetY() - verticalMargin) : clientArea.GetY());

      _measuredSize = fullClientArea;
#if ((COURIER_VERSION_MAJOR > 3) || ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5)))
      AbstractNodePointer abstractNode(&node);
      return baseLayouter->OnMeasure(abstractNode, fullClientArea);
#else
      return baseLayouter->OnMeasure(node, fullClientArea);
#endif
   }
   return Candera::Vector2();
}


#if defined SESA_ARABIC_LAYOUT_FIX
void FlexHookLayouter::OnArrange(Candera::Node2D& node, const Candera::Rectangle& clientArea)
{
   const Candera::Rectangle fullClientArea(clientArea.GetPosition(), _measuredSize);

   if (Candera::ArabicLayouterPatch::IsSceneEnabled(node))
   {
      FEATSTD_LINT_NEXT_EXPRESSION(740, "Intended downcast.");
      BaseLayouter* baseLayouter = static_cast<BaseLayouter*>((0 != _originalLayouter) ? _originalLayouter : DefaultLayouter::GetInstance());
      if (0 != baseLayouter)
      {
#if ((COURIER_VERSION_MAJOR > 3) || ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5)))
         AbstractNodePointer abstractNode(&node);
         baseLayouter->OnArrange(abstractNode, fullClientArea);
#else
         baseLayouter->OnArrange(node, fullClientArea);
#endif
      }
   }
   else
   {
      FEATSTD_LINT_NEXT_EXPRESSION(740, "Intended downcast.");
      BaseLayouter* baseLayouter = static_cast<BaseLayouter*>((0 != _originalLayouter) ? _originalLayouter : DefaultLayouter::GetInstance());
      if (0 != baseLayouter)
      {
#if ((COURIER_VERSION_MAJOR > 3) || ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5)))
         AbstractNodePointer abstractNode(&node);
         baseLayouter->OnArrange(abstractNode, fullClientArea);
#else
         baseLayouter->OnArrange(node, fullClientArea);
#endif
      }

      if (FlexHookLayouter::ShouldNotifyListeners())
      {
         for (Int i = 0; i < (Int) _listeners.Size(); i++)
         {
            if (0 != _listeners[i])
            {
               _listeners[i]->OnPostArrange(node, fullClientArea);
            }
         }
      }
   }
}


void FlexHookLayouter::OnClipping(Candera::Node2D& node, const Candera::Rectangle& clientArea)
{
   if (Candera::ArabicLayouterPatch::IsSceneEnabled(node))
   {
      if (FlexHookLayouter::ShouldNotifyListeners())
      {
         for (Int32 i = 0; i < (Int) _listeners.Size(); i++)
         {
            if (0 != _listeners[i])
            {
               _listeners[i]->OnPostArrange(node, clientArea);
            }
         }
      }
   }
}


#else
void FlexHookLayouter::OnArrange(Candera::Node2D& node, const Candera::Rectangle& clientArea)
{
   FEATSTD_LINT_NEXT_EXPRESSION(740, "Intended downcast.");
   BaseLayouter* baseLayouter = static_cast<BaseLayouter*>((0 != _originalLayouter) ? _originalLayouter : DefaultLayouter::GetInstance());
   if (0 != baseLayouter)
   {
      baseLayouter->OnArrange(node, clientArea);
   }

   if (FlexHookLayouter::ShouldNotifyListeners())
   {
      for (Int32 i = 0; i < _listeners.Size(); i++)
      {
         if (0 != _listeners[i])
         {
            _listeners[i]->OnPostArrange(node, clientArea);
         }
      }
   }
}


void FlexHookLayouter::OnClipping(Candera::Node2D& /*node*/, const Candera::Rectangle& /*clientArea*/)
{
}


#endif

_TODO("CGI3 Layouter behaviour : Clone <> CloneSelf has to be checked in all classes")
Candera::Layouter* FlexHookLayouter::Clone() const

{
   if (0 != _originalLayouter)
   {
      BaseLayouter* baseLayouter = static_cast<BaseLayouter*>(_originalLayouter);

      return CANDERA_NEW(FlexHookLayouter)(baseLayouter->Clone());
   }
   return CANDERA_NEW(FlexHookLayouter)(0);
}
