/* ***************************************************************************************
* FILE:          FlexCanvasLayouter.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FlexCanvasLayouter is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "FlexCanvasLayouter.h"

#include "FeatStd/Util/StaticObject.h"


using namespace Candera;


void FlexCanvasLayouter::SetLayoutChildren(Candera::Node2D& node, const bool& value)
{
   static_cast<void>(node.SetValue(CdaDynamicPropertyInstance(LayoutChildren), value));
}


bool FlexCanvasLayouter::IsLayoutChildrenSet(const Candera::Node2D& node)
{
   return node.IsValueSet(CdaDynamicPropertyInstance(LayoutChildren));
}


bool FlexCanvasLayouter::GetLayoutChildren(const Candera::Node2D& node)
{
   return node.GetValue(CdaDynamicPropertyInstance(LayoutChildren));
}


FlexCanvasLayouter* FlexCanvasLayouter::GetInstance()
{
   FEATSTD_UNSYNCED_STATIC_OBJECT(FlexCanvasLayouter, s_flexCanvasLayouter);
   return &s_flexCanvasLayouter;
}


void FlexCanvasLayouter::Dispose()
{
}


Candera::Vector2 FlexCanvasLayouter::OnMeasure(Candera::Node2D& node, const Candera::Vector2& clientArea)
{
   Float width = 0.0F;
   Float height = 0.0F;
   Candera::Node2D* child = node.GetFirstChild();
   while (child != 0)
   {
      Layouter* childLayouter = child->GetLayouter();
      if (childLayouter != 0)
      {
         Candera::Vector2 childArea(clientArea.GetX() - child->GetPosition().GetX(), clientArea.GetY() - child->GetPosition().GetY());
         if (childArea.GetX() < 0.0F)
         {
            childArea.SetX(0.0F);
         }
         if (childArea.GetY() < 0.0F)
         {
            childArea.SetY(0.0F);
         }
         childLayouter->Measure(*child, childArea);
         Candera::Vector2 preferredChildSize = childLayouter->GetClientSize(*child);
         if (width < preferredChildSize.GetX())
         {
            width = preferredChildSize.GetX();
         }
         if (height < preferredChildSize.GetY())
         {
            height = preferredChildSize.GetY();
         }
      }
      child = child->GetNextSibling();
   }

   if (Layouter::IsSizeSet(node))
   {
      Candera::Vector2 size = Layouter::GetSize(node);
      if (size.GetX() > 0.0F)
      {
         width = size.GetX();
      }
      if (size.GetY() > 0.0F)
      {
         height = size.GetY();
      }
   }
   return Candera::Vector2(width, height);
}


void FlexCanvasLayouter::OnArrange(Candera::Node2D& node, const Candera::Rectangle& clientArea)
{
   if (GetLayoutChildren(node))
   {
      Candera::Node2D* child = node.GetFirstChild();
      while (child != 0)
      {
         Layouter* childLayouter = child->GetLayouter();
         if (childLayouter != 0)
         {
            Float clientWidth = clientArea.GetWidth();
            Float clientHeight = clientArea.GetHeight();
            if (Layouter::IsSizeSet(*child))
            {
               Candera::Vector2 size = Layouter::GetSize(*child);
               if ((size.GetX() > 0.0F) && ((size.GetX() < clientWidth) || (clientWidth < 0.0F)))
               {
                  clientWidth = size.GetX();
               }
               if ((size.GetY() > 0.0F) && ((size.GetY() < clientHeight) || (clientHeight < 0.0F)))
               {
                  clientHeight = size.GetY();
               }
            }
            Candera::Rectangle childArea(child->GetPosition().GetX(), child->GetPosition().GetY(), clientWidth, clientHeight);
            childLayouter->Arrange(*child, childArea);
         }
         child = child->GetNextSibling();
      }
   }
   node.SetPosition(clientArea.GetPosition());
}


FlexCanvasLayouter::FlexCanvasLayouter()
{
}
