/* ***************************************************************************************
* FILE:          ListProviderEventInfo.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ListProviderEventInfo is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(ListProviderEventInfo_H)
#define ListProviderEventInfo_H

#include <Courier/Util/Identifier.h>
#include "ServersData.h"

class ListProviderEventInfo
{
   public:
      ListProviderEventInfo();
      ListProviderEventInfo(unsigned listid, ServersDataItemHdlRow hdlRow, ServersDataItemHdlCol hdlCol, ServersDataItemFlags flags);

      unsigned getListId() const;
      ServersDataItemHdlRow getHdlRow() const;
      ServersDataItemHdlCol getHdlCol() const;
      ServersDataItemFlags  getFlags()  const;

      bool isValid() const;
      void setInValid();
      static void SetItemIdentifier(const Courier::Identifier& buttonId, const ListProviderEventInfo ev);
      static void ClearItemIdentifier(const Courier::Identifier& buttonId);
      static bool GetItemIdentifierInfo(const Courier::Identifier& buttonId, ListProviderEventInfo& info, unsigned listIdToMatch = 0xFFFF);

      static const char* DebugDumpEntry(int i);

   private:
      ServersDataItemHdlRow _hdlRow;         // normally the index of the row
      ServersDataItemHdlCol _hdlCol;         // if more than 1 active element in one list row, e.g. Button in a button line
      ServersDataItemFlags  _flags;
      unsigned              _listId;         // the list id for generic access
};


#endif
